/*
 * Decompiled with CFR 0.152.
 */
package demos.Lines;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Joins
extends ControlsSurface
implements ChangeListener {
    protected int joinType = 0;
    protected float bswidth = 20.0f;
    protected JSlider slider;
    protected JLabel label;

    public Joins() {
        this.setBackground(Color.white);
        this.slider = new JSlider(1, 0, 100, (int)(this.bswidth * 2.0f));
        this.slider.setPreferredSize(new Dimension(15, 100));
        this.slider.addChangeListener(this);
        this.setControls(new Component[]{new DemoControls(this), this.slider});
        this.setConstraints(new String[]{"North", "West"});
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.getImageType() <= 1) {
            this.setImageType(2);
        }
        this.bswidth = (float)this.slider.getValue() / 2.0f;
        this.label.setText("width=" + String.valueOf(this.bswidth));
        this.label.repaint();
        this.repaint();
    }

    public void render(int n, int n2, Graphics2D graphics2D) {
        BasicStroke basicStroke = new BasicStroke(this.bswidth, 0, this.joinType);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)(-n) / 4.0f, (float)(-n2) / 12.0f);
        generalPath.lineTo((float)n / 4.0f, (float)(-n2) / 12.0f);
        generalPath.lineTo((float)(-n) / 6.0f, (float)n2 / 4.0f);
        generalPath.lineTo(0.0f, (float)(-n2) / 4.0f);
        generalPath.lineTo((float)n / 6.0f, (float)n2 / 4.0f);
        generalPath.closePath();
        generalPath.closePath();
        graphics2D.translate(n / 2, n2 / 2);
        graphics2D.setColor(Color.black);
        graphics2D.draw(basicStroke.createStrokedShape(generalPath));
    }

    public static void main(String[] stringArray) {
        Surface.createDemoFrame(new Joins());
    }

    class DemoControls
    extends CustomControls
    implements ActionListener {
        Joins demo;
        int[] joinType = new int[]{0, 1, 2};
        String[] joinName = new String[]{"Mitered Join", "Rounded Join", "Beveled Join"};
        JMenu menu;
        JMenuItem[] menuitem = new JMenuItem[this.joinType.length];
        JoinIcon[] icons = new JoinIcon[this.joinType.length];
        JToolBar toolbar;

        public DemoControls(Joins joins2) {
            super(joins2.name);
            this.demo = joins2;
            this.setBackground(Color.gray);
            this.setLayout(new BorderLayout());
            this.setBorder(new EmptyBorder(2, 2, 2, 2));
            Joins.this.label = new JLabel("width=" + String.valueOf(joins2.bswidth));
            Font font = new Font("serif", 1, 14);
            Joins.this.label.setFont(font);
            Joins.this.label.setForeground(Color.lightGray);
            this.add("West", Joins.this.label);
            JMenuBar jMenuBar = new JMenuBar();
            this.add("East", jMenuBar);
            this.menu = jMenuBar.add(new JMenu(this.joinName[0]));
            font = new Font("serif", 0, 10);
            this.menu.setFont(font);
            int n = 0;
            while (n < this.joinType.length) {
                this.icons[n] = new JoinIcon(this.joinType[n]);
                this.menuitem[n] = this.menu.add(new JMenuItem(this.joinName[n]));
                this.menuitem[n].setFont(font);
                this.menuitem[n].setIcon(this.icons[n]);
                this.menuitem[n].addActionListener(this);
                ++n;
            }
            this.menu.setIcon(this.icons[0]);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = 0;
            while (n < this.joinType.length) {
                if (actionEvent.getSource().equals(this.menuitem[n])) {
                    this.demo.joinType = this.joinType[n];
                    this.menu.setIcon(this.icons[n]);
                    this.menu.setText(this.joinName[n]);
                    break;
                }
                ++n;
            }
            this.demo.repaint();
        }

        public Dimension getPreferredSize() {
            return new Dimension(200, 28);
        }

        public void run() {
            try {
                Thread.sleep(999L);
            }
            catch (Exception exception) {
                return;
            }
            Thread thread = Thread.currentThread();
            while (this.thread == thread) {
                int n = 0;
                while (n < this.menuitem.length) {
                    this.menuitem[n].doClick();
                    int n2 = 10;
                    while (n2 < 60) {
                        this.demo.slider.setValue(n2);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                        n2 += 2;
                    }
                    try {
                        Thread.sleep(999L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    ++n;
                }
            }
            this.thread = null;
        }

        class JoinIcon
        implements Icon {
            int joinType;

            public JoinIcon(int n) {
                this.joinType = n;
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                BasicStroke basicStroke = new BasicStroke(8.0f, 0, this.joinType);
                ((Graphics2D)graphics).setStroke(basicStroke);
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(0.0f, 3.0f);
                generalPath.lineTo(this.getIconWidth() - 2, this.getIconHeight() / 2);
                generalPath.lineTo(0.0f, this.getIconHeight());
                ((Graphics2D)graphics).draw(generalPath);
            }

            public int getIconWidth() {
                return 20;
            }

            public int getIconHeight() {
                return 20;
            }
        }
    }
}

