/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Util {
    public static ProgramElementDoc[] excludeDeprecatedMembers(ProgramElementDoc[] programElementDocArray) {
        return Util.toProgramElementDocArray(Util.excludeDeprecatedMembersAsList(programElementDocArray));
    }

    public static List excludeDeprecatedMembersAsList(ProgramElementDoc[] programElementDocArray) {
        ArrayList<ProgramElementDoc> arrayList = new ArrayList<ProgramElementDoc>();
        int n = 0;
        while (n < programElementDocArray.length) {
            if (programElementDocArray[n].tags("deprecated").length == 0) {
                arrayList.add(programElementDocArray[n]);
            }
            ++n;
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public static ProgramElementDoc[] toProgramElementDocArray(List list) {
        ProgramElementDoc[] programElementDocArray = new ProgramElementDoc[list.size()];
        int n = 0;
        while (n < list.size()) {
            programElementDocArray[n] = (ProgramElementDoc)list.get(n);
            ++n;
        }
        return programElementDocArray;
    }

    public static boolean nonPublicMemberFound(ProgramElementDoc[] programElementDocArray) {
        int n = 0;
        while (n < programElementDocArray.length) {
            if (!programElementDocArray[n].isPublic()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static MethodDoc findMethod(ClassDoc classDoc, MethodDoc methodDoc) {
        MethodDoc[] methodDocArray = classDoc.methods();
        int n = 0;
        while (n < methodDocArray.length) {
            if (methodDoc.name().equals(methodDocArray[n].name()) && methodDoc.signature().equals(methodDocArray[n].signature())) {
                return methodDocArray[n];
            }
            ++n;
        }
        return null;
    }

    public static boolean isCoreClass(ClassDoc classDoc) {
        return classDoc.containingClass() == null || classDoc.isStatic();
    }

    public static boolean matches(ProgramElementDoc programElementDoc, ProgramElementDoc programElementDoc2) {
        if (programElementDoc instanceof ExecutableMemberDoc && programElementDoc2 instanceof ExecutableMemberDoc) {
            ExecutableMemberDoc executableMemberDoc = (ExecutableMemberDoc)programElementDoc;
            ExecutableMemberDoc executableMemberDoc2 = (ExecutableMemberDoc)programElementDoc2;
            return executableMemberDoc.name().equals(executableMemberDoc2.name()) && executableMemberDoc.signature().equals(executableMemberDoc2.signature());
        }
        return programElementDoc.name().equals(programElementDoc2.name());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFile(File file, File file2) throws IOException {
        byte[] byArray = new byte[512];
        int n = 0;
        FileInputStream fileInputStream = new FileInputStream(file2);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            try {
                while ((n = fileInputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                Object var9_7 = null;
                fileInputStream.close();
                fileOutputStream.close();
                return;
            }
            catch (SecurityException securityException) {
                Object var9_8 = null;
                fileInputStream.close();
                fileOutputStream.close();
                return;
            }
            Object var9_6 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            fileInputStream.close();
            fileOutputStream.close();
            throw throwable;
        }
        fileInputStream.close();
        fileOutputStream.close();
    }

    public static ClassDoc[] getAllInterfaces(ClassDoc classDoc) {
        Object object;
        HashSet hashSet = new HashSet();
        Util.buildInterfaces(hashSet, classDoc);
        if (classDoc.isClass()) {
            object = classDoc.superclass();
            while (object != null) {
                Util.buildInterfaces(hashSet, (ClassDoc)object);
                object = object.superclass();
            }
        }
        object = new ClassDoc[hashSet.size()];
        hashSet.toArray((T[])object);
        Arrays.sort(object);
        return object;
    }

    private static void buildInterfaces(Set set, ClassDoc classDoc) {
        ClassDoc[] classDocArray = classDoc.interfaces();
        int n = 0;
        while (n < classDocArray.length) {
            set.add(classDocArray[n]);
            Util.buildInterfaces(set, classDocArray[n]);
            ++n;
        }
    }

    public static List asList(ProgramElementDoc[] programElementDocArray) {
        ArrayList<ProgramElementDoc> arrayList = new ArrayList<ProgramElementDoc>();
        int n = 0;
        while (n < programElementDocArray.length) {
            arrayList.add(programElementDocArray[n]);
            ++n;
        }
        return arrayList;
    }
}

