/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.tools.doclets.Util;
import java.util.ArrayList;
import java.util.List;

public class ImplementedMethods {
    private List methlist = new ArrayList();
    private final ClassDoc classdoc;
    private final MethodDoc method;

    public ImplementedMethods(MethodDoc methodDoc) {
        this.method = methodDoc;
        this.classdoc = methodDoc.containingClass();
    }

    public MethodDoc[] build() {
        ClassDoc classDoc = this.classdoc;
        while (classDoc != null) {
            this.buildImplementedMethodList(classDoc.interfaces());
            classDoc = classDoc.superclass();
        }
        return this.methlist.toArray(new MethodDoc[this.methlist.size()]);
    }

    private void buildImplementedMethodList(ClassDoc[] classDocArray) {
        int n = 0;
        while (n < classDocArray.length) {
            MethodDoc methodDoc = Util.findMethod(classDocArray[n], this.method);
            if (methodDoc != null) {
                this.removeOverriddenMethod(methodDoc);
                if (!this.overriddingMethodFound(methodDoc)) {
                    this.methlist.add(this.method);
                }
            }
            ClassDoc[] classDocArray2 = classDocArray[n].interfaces();
            this.buildImplementedMethodList(classDocArray2);
            ++n;
        }
    }

    private void removeOverriddenMethod(MethodDoc methodDoc) {
        ClassDoc classDoc = methodDoc.overriddenClass();
        if (classDoc != null) {
            int n = 0;
            while (n < this.methlist.size()) {
                ClassDoc classDoc2 = ((MethodDoc)this.methlist.get(n)).containingClass();
                if (classDoc2 == classDoc || classDoc.subclassOf(classDoc2)) {
                    this.methlist.remove(n);
                    return;
                }
                ++n;
            }
        }
    }

    private boolean overriddingMethodFound(MethodDoc methodDoc) {
        ClassDoc classDoc = methodDoc.containingClass();
        int n = 0;
        while (n < this.methlist.size()) {
            ClassDoc classDoc2 = ((MethodDoc)this.methlist.get(n)).overriddenClass();
            if (classDoc2 == classDoc || classDoc2.subclassOf(classDoc)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

