/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;

public abstract class ResourceBundle {
    protected ResourceBundle parent;
    private static Hashtable resource_cache = new Hashtable();

    public Locale getLocale() {
        return null;
    }

    public final String getString(String key) {
        return (String)this.getObject(key);
    }

    public final String[] getStringArray(String key) {
        return (String[])this.getObject(key);
    }

    public final Object getObject(String key) {
        try {
            return this.handleGetObject(key);
        }
        catch (MissingResourceException ex) {
            if (this.parent != null) {
                return this.parent.getObject(key);
            }
            throw ex;
        }
    }

    public static final ResourceBundle getBundle(String baseName) {
        return ResourceBundle.getBundle(baseName, Locale.getDefault());
    }

    private static final ResourceBundle trySomeGetBundle(String bundleName, String stopHere, ClassLoader loader) {
        ResourceBundle needs_parent = null;
        ResourceBundle result = null;
        while (true) {
            try {
                Class rbc = Class.forName(bundleName, true, loader);
                ResourceBundle r = null;
                try {
                    r = (ResourceBundle)rbc.newInstance();
                }
                catch (IllegalAccessException ex) {
                }
                catch (InstantiationException ex) {
                    // empty catch block
                }
                if (r != null) {
                    if (result == null) {
                        result = r;
                    }
                    if (needs_parent != null) {
                        needs_parent.setParent(r);
                    }
                    needs_parent = r;
                }
            }
            catch (ClassNotFoundException i) {
                // empty catch block
            }
            InputStream i = loader.getResourceAsStream(bundleName.replace('.', '/') + ".properties");
            if (i != null) {
                try {
                    return new PropertyResourceBundle(i);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (bundleName.equals(stopHere)) {
                return result;
            }
            int last = bundleName.lastIndexOf(95);
            if (last == -1) {
                return result;
            }
            bundleName = bundleName.substring(0, last);
        }
    }

    private static final synchronized ResourceBundle partialGetBundle(String baseName, Locale locale, boolean langStop, ClassLoader loader) {
        String bundleName = baseName + "_" + locale.toString();
        Object obj = resource_cache.get(bundleName);
        if (obj != null) {
            return (ResourceBundle)obj;
        }
        String stopHere = baseName + (langStop ? "_" + locale.getLanguage() : "");
        ResourceBundle rb = ResourceBundle.trySomeGetBundle(bundleName, stopHere, loader);
        if (rb != null) {
            resource_cache.put(bundleName, rb);
        }
        return rb;
    }

    public static final ResourceBundle getBundle(String baseName, Locale locale) {
        return ResourceBundle.getBundle(baseName, locale, ClassLoader.getSystemClassLoader());
    }

    public static final ResourceBundle getBundle(String baseName, Locale locale, ClassLoader loader) {
        if (baseName == null) {
            throw new NullPointerException();
        }
        ResourceBundle rb = ResourceBundle.partialGetBundle(baseName, locale, false, loader);
        if (rb != null) {
            return rb;
        }
        if (!locale.equals(Locale.getDefault()) && (rb = ResourceBundle.partialGetBundle(baseName, Locale.getDefault(), true, loader)) != null) {
            return rb;
        }
        throw new MissingResourceException("can't load bundle", baseName, "bundle");
    }

    protected void setParent(ResourceBundle parent) {
        this.parent = parent;
    }

    protected abstract Object handleGetObject(String var1) throws MissingResourceException;

    public abstract Enumeration getKeys();
}

