/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.gcj.convert.BytesToUnicode;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class InputStreamReader
extends Reader {
    BufferedInputStream in;
    char[] work;
    int wpos;
    int wcount;
    BytesToUnicode converter;

    public InputStreamReader(InputStream in) {
        this(in, BytesToUnicode.getDefaultDecoder());
    }

    public InputStreamReader(InputStream in, String enc) throws UnsupportedEncodingException {
        this(in, BytesToUnicode.getDecoder(enc));
    }

    private InputStreamReader(InputStream in, BytesToUnicode decoder) {
        this.in = in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
        this.lock = in;
        this.converter = decoder;
        this.converter.setInput(this.in.buf, 0, 0);
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.in != null) {
                    this.in.close();
                }
                this.in = null;
                this.work = null;
                this.wcount = 0;
                this.wpos = 0;
            }
            finally {
                Object var3_2 = null;
            }
            return;
        }
    }

    public String getEncoding() {
        return this.converter.getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.in == null) {
                    throw new IOException("Stream closed");
                }
                if (this.wpos < this.wcount) {
                    return true;
                }
                if (this.work == null) {
                    this.work = new char[100];
                    this.wpos = 0;
                    this.wcount = 0;
                }
                do {
                    if (this.in.available() <= 0) {
                        return false;
                    }
                    this.in.mark(1);
                    int b = this.in.read();
                    if (b < 0) {
                        return true;
                    }
                    this.in.reset();
                    this.converter.setInput(this.in.buf, this.in.pos, this.in.count);
                    this.wpos = 0;
                    this.wcount = this.converter.read(this.work, 0, this.work.length);
                    this.in.skip(this.converter.inpos - this.in.pos);
                } while (this.wcount <= 0);
                return true;
            }
            catch (Throwable throwable) {
                Object var4_10 = null;
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(char[] buf, int offset, int length) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                int count;
                if (this.in == null) {
                    throw new IOException("Stream closed");
                }
                int wavail = this.wcount - this.wpos;
                if (wavail > 0) {
                    if (length > wavail) {
                        length = wavail;
                    }
                    System.arraycopy(this.work, this.wpos, buf, offset, length);
                    this.wpos += length;
                    return length;
                }
                if (length == 0) {
                    return 0;
                }
                do {
                    this.in.mark(1);
                    int b = this.in.read();
                    if (b < 0) {
                        return -1;
                    }
                    this.in.reset();
                    this.converter.setInput(this.in.buf, this.in.pos, this.in.count);
                    count = this.converter.read(buf, offset, length);
                    this.in.skip(this.converter.inpos - this.in.pos);
                } while (count <= 0);
                return count;
            }
            catch (Throwable throwable) {
                Object var7_16 = null;
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.in == null) {
                    throw new IOException("Stream closed");
                }
                int wavail = this.wcount - this.wpos;
                if (wavail > 0) {
                    return this.work[this.wpos++];
                }
                if (this.work == null) {
                    this.work = new char[100];
                    this.wpos = 0;
                    this.wcount = 0;
                } else if (wavail == 0) {
                    this.wpos = 0;
                    this.wcount = 0;
                }
                int count = this.read(this.work, this.wpos, this.work.length - this.wpos);
                if (count <= 0) {
                    return -1;
                }
                this.wcount = this.wpos + count;
                return this.work[this.wpos++];
            }
            catch (Throwable throwable) {
                Object var4_11 = null;
                throw throwable;
            }
        }
    }
}

