/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

public abstract class Point2D
implements Cloneable {
    public abstract double getX();

    public abstract double getY();

    public abstract void setLocation(double var1, double var3);

    protected Point2D() {
    }

    public void setLocation(Point2D pt) {
        this.setLocation(pt.getX(), pt.getY());
    }

    public static double distanceSq(double X1, double Y1, double X2, double Y2) {
        return (X2 -= X1) * X2 + (Y2 -= Y1) * Y2;
    }

    public static double distance(double X1, double Y1, double X2, double Y2) {
        return Math.sqrt(Point2D.distance(X1, Y1, X2, Y2));
    }

    public double distanceSq(double PX, double PY) {
        return Point2D.distanceSq(this.getX(), PX, this.getY(), PY);
    }

    public double distance(double PX, double PY) {
        return Point2D.distance(this.getX(), PX, this.getY(), PY);
    }

    public double distanceSq(Point2D pt) {
        return Point2D.distanceSq(this.getX(), pt.getX(), this.getY(), pt.getY());
    }

    public double distance(Point2D pt) {
        return Point2D.distance(this.getX(), pt.getX(), this.getY(), pt.getY());
    }

    public int hashCode() {
        return (int)this.getX() ^ (int)this.getY();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException _) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Point2D)) {
            return false;
        }
        Point2D p = (Point2D)o;
        return this.getX() == p.getX() && this.getY() == p.getY();
    }

    public static class Float
    extends Point2D {
        public float x;
        public float y;

        public Float() {
            this.x = 0.0f;
            this.y = 0.0f;
        }

        public Float(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void setLocation(double x, double y) {
            this.x = (float)x;
            this.y = (float)y;
        }

        public void setLocation(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ")";
        }
    }

    public static class Double
    extends Point2D {
        public double x;
        public double y;

        public Double() {
            this.x = 0.0;
            this.y = 0.0;
        }

        public Double(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void setLocation(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ")";
        }
    }
}

