/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import gnu.gcj.awt.GLightweightPeer;
import java.awt.AWTError;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.event.AWTEventListener;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.LightweightPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.Hashtable;

public abstract class Toolkit {
    static Toolkit defaultToolkit;
    PropertyChangeSupport changeSupport;
    Hashtable desktopProperties;

    private /* synthetic */ void finit$() {
        this.changeSupport = new PropertyChangeSupport(this);
        this.desktopProperties = new Hashtable();
    }

    public static Toolkit getDefaultToolkit() {
        if (defaultToolkit != null) {
            return defaultToolkit;
        }
        String tk_class_name = System.getProperty("awt.toolkit");
        if (tk_class_name == null) {
            tk_class_name = "gnu.awt.gtk.GtkToolkit";
        }
        try {
            Class toolkit_class = Class.forName(tk_class_name);
            defaultToolkit = (Toolkit)toolkit_class.newInstance();
        }
        catch (Exception x) {
            throw new AWTError("Toolkit class " + tk_class_name + " could not be initialized:\n  " + x);
        }
        return defaultToolkit;
    }

    protected abstract ButtonPeer createButton(Button var1);

    protected abstract TextFieldPeer createTextField(TextField var1);

    protected abstract LabelPeer createLabel(Label var1);

    protected abstract ListPeer createList(List var1);

    protected abstract CheckboxPeer createCheckbox(Checkbox var1);

    protected abstract ScrollbarPeer createScrollbar(Scrollbar var1);

    protected abstract ScrollPanePeer createScrollPane(ScrollPane var1);

    protected abstract TextAreaPeer createTextArea(TextArea var1);

    protected abstract ChoicePeer createChoice(Choice var1);

    protected abstract FramePeer createFrame(Frame var1);

    protected abstract CanvasPeer createCanvas(Canvas var1);

    protected abstract PanelPeer createPanel(Panel var1);

    protected abstract WindowPeer createWindow(Window var1);

    protected abstract DialogPeer createDialog(Dialog var1);

    protected abstract MenuBarPeer createMenuBar(MenuBar var1);

    protected abstract MenuPeer createMenu(Menu var1);

    protected abstract PopupMenuPeer createPopupMenu(PopupMenu var1);

    protected abstract MenuItemPeer createMenuItem(MenuItem var1);

    protected abstract FileDialogPeer createFileDialog(FileDialog var1);

    protected abstract CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem var1);

    protected LightweightPeer createComponent(Component target) {
        return GLightweightPeer.INSTANCE;
    }

    protected abstract FontPeer getFontPeer(String var1, int var2);

    protected void loadSystemColors(int[] systemColors) {
    }

    public abstract Dimension getScreenSize();

    public abstract int getScreenResolution();

    public abstract ColorModel getColorModel();

    public abstract String[] getFontList();

    public abstract FontMetrics getFontMetrics(Font var1);

    public abstract void sync();

    public abstract Image getImage(String var1);

    public abstract Image getImage(URL var1);

    public abstract Image createImage(String var1);

    public abstract Image createImage(URL var1);

    public abstract boolean prepareImage(Image var1, int var2, int var3, ImageObserver var4);

    public abstract int checkImage(Image var1, int var2, int var3, ImageObserver var4);

    public abstract Image createImage(ImageProducer var1);

    public Image createImage(byte[] imagedata) {
        return this.createImage(imagedata, 0, imagedata.length);
    }

    public abstract Image createImage(byte[] var1, int var2, int var3);

    public abstract void beep();

    public abstract Clipboard getSystemClipboard();

    public int getMenuShortcutKeyMask() {
        return 2;
    }

    public boolean getLockingKeyState(int keyCode) {
        if (keyCode != 20 && keyCode != 144 && keyCode != 145) {
            throw new IllegalArgumentException();
        }
        throw new UnsupportedOperationException();
    }

    public void setLockingKeyState(int keyCode, boolean on) {
        if (keyCode != 20 && keyCode != 144 && keyCode != 145) {
            throw new IllegalArgumentException();
        }
        throw new UnsupportedOperationException();
    }

    protected static Container getNativeContainer(Component c) {
        while (c != null) {
            if (!c.isLightweight()) {
                return (Container)c;
            }
            c = c.getParent();
        }
        return null;
    }

    public Cursor createCustomCursor(Image cursor, Point hotSpot, String name) {
        return null;
    }

    public Dimension getBestCursorSize(int preferredWidth, int preferredHeight) {
        return new Dimension(0, 0);
    }

    public int getMaximumCursorColors() {
        return 0;
    }

    public static String getProperty(String key, String defaultValue) {
        return defaultValue;
    }

    public final EventQueue getSystemEventQueue() {
        return this.getSystemEventQueueImpl();
    }

    protected abstract EventQueue getSystemEventQueueImpl();

    public final Object getDesktopProperty(String propertyName) {
        return this.desktopProperties.get(propertyName);
    }

    protected final void setDesktopProperty(String name, Object newValue) {
        Object oldValue = this.getDesktopProperty(name);
        this.desktopProperties.put(name, newValue);
        this.changeSupport.firePropertyChange(name, oldValue, newValue);
    }

    protected Object lazilyLoadDesktopProperty(String name) {
        return null;
    }

    protected void initializeDesktopProperties() {
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener pcl) {
        this.changeSupport.addPropertyChangeListener(name, pcl);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener pcl) {
        this.changeSupport.removePropertyChangeListener(name, pcl);
    }

    public void addAWTEventListener(AWTEventListener listener, long eventMask) {
    }

    public void removeAWTEventListener(AWTEventListener listener) {
    }

    public Toolkit() {
        this.finit$();
    }
}

