/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Font;
import java.io.Serializable;

public class FontMetrics
implements Serializable {
    protected Font font;

    protected FontMetrics(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public int getLeading() {
        return this.getMaxAscent() + this.getMaxDescent() - (this.getAscent() + this.getDescent());
    }

    public int getAscent() {
        return this.getHeight() - (this.getDescent() + this.getLeading());
    }

    public int getDescent() {
        return this.getHeight() - (this.getLeading() + this.getDescent());
    }

    public int getHeight() {
        return this.getLeading() + this.getAscent() + this.getDescent();
    }

    public int getMaxAscent() {
        return this.getAscent();
    }

    public int getMaxDescent() {
        return this.getDescent();
    }

    public int getMaxDecent() {
        return this.getMaxDescent();
    }

    public int getMaxAdvance() {
        return -1;
    }

    public int charWidth(int ch) {
        return this.charWidth((char)ch);
    }

    public int charWidth(char ch) {
        Character chObj = new Character(ch);
        return this.stringWidth(chObj.toString());
    }

    public int stringWidth(String str) {
        return this.charsWidth(str.toCharArray(), 0, str.length());
    }

    public int charsWidth(char[] data, int off, int len) {
        return this.stringWidth(new String(data, off, len));
    }

    public int bytesWidth(byte[] data, int off, int len) {
        return this.stringWidth(new String(data, off, len));
    }

    public int[] getWidths() {
        int[] widths = new int[256];
        for (int c = 0; c < 256; ++c) {
            widths[c] = this.charWidth((char)c);
        }
        return widths;
    }

    public boolean hasUniformLineMetrics() {
        return false;
    }

    public String toString() {
        return this.getClass() + "[font=" + this.font + ",ascent=" + this.getAscent() + ",descent=" + this.getDescent() + ",height=" + this.getHeight() + "]";
    }
}

