/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.ChoicePeer;
import java.util.ArrayList;

public class Choice
extends Component
implements ItemSelectable {
    private ItemListener listeners;
    ArrayList items = new ArrayList();
    int selected = -1;

    public synchronized void add(String item) {
        if (item == null) {
            throw new IllegalArgumentException("item must be non-null");
        }
        this.items.add(item);
        int i = this.items.size() - 1;
        if (this.peer != null) {
            ChoicePeer cp = (ChoicePeer)this.peer;
            cp.add(item, i);
        }
        if (i == 0) {
            this.select(0);
        }
    }

    public void addItem(String item) {
        this.add(item);
    }

    public synchronized void addItemListener(ItemListener listener) {
        this.listeners = AWTEventMulticaster.add(this.listeners, listener);
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createChoice(this);
        }
    }

    public int countItems() {
        return this.getItemCount();
    }

    public String getItem(int index) {
        return (String)this.items.get(index);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public int getSelectedIndex() {
        return this.selected;
    }

    public synchronized String getSelectedItem() {
        if (this.selected == -1) {
            return null;
        }
        return (String)this.items.get(this.selected);
    }

    public synchronized Object[] getSelectedObjects() {
        Object[] r = this.selected != -1 ? new Object[]{this.items.get(this.selected)} : new Object[]{};
        return r;
    }

    public synchronized void insert(String item, int index) {
        if (index > this.items.size()) {
            index = this.items.size();
        }
        this.items.add(index, item);
        if (this.peer != null) {
            ChoicePeer cp = (ChoicePeer)this.peer;
            cp.add(item, index);
        }
        if (this.items.size() == 1 || this.selected >= index) {
            this.select(0);
        }
    }

    protected String paramString() {
        return "Choice[selected=" + this.selected + "]";
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)event);
        } else {
            super.processEvent(event);
        }
    }

    protected void processItemEvent(ItemEvent event) {
        if (this.listeners != null) {
            this.listeners.itemStateChanged(event);
        }
    }

    public synchronized void remove(String item) {
        int size = this.items.size();
        for (int i = 0; i < size; ++i) {
            if (!item.equals(this.items.get(i))) continue;
            this.remove(i);
            break;
        }
        throw new IllegalArgumentException("item \"" + item + "\" not in Choice");
    }

    public synchronized void remove(int index) {
        this.items.remove(index);
        if (this.peer != null) {
            ChoicePeer cp = (ChoicePeer)this.peer;
            cp.remove(index);
        }
        if (index == this.selected) {
            this.select(0);
        } else if (this.selected > index) {
            this.selected += -1;
        }
    }

    public synchronized void removeAll() {
        int oldsize = this.items.size();
        this.items.clear();
        this.selected = -1;
        if (this.peer != null) {
            ChoicePeer cp = (ChoicePeer)this.peer;
            for (int i = 0; i < oldsize; ++i) {
                cp.remove(0);
            }
        }
    }

    public synchronized void removeItemListener(ItemListener listener) {
        this.listeners = AWTEventMulticaster.remove(this.listeners, listener);
    }

    public synchronized void select(String item) {
        int size = this.items.size();
        for (int i = 0; i < size; ++i) {
            if (!item.equals(this.items.get(i))) continue;
            this.select(i);
            break;
        }
    }

    public synchronized void select(int index) {
        if (index < 0 || index > this.items.size()) {
            throw new IllegalArgumentException("index out of range");
        }
        this.selected = index;
        if (this.peer != null) {
            ChoicePeer cp = (ChoicePeer)this.peer;
            cp.select(index);
        }
    }
}

