/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2001 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
//---------------------------------------------------------------------------
#ifndef USERINFO_H
#define USERINFO_H
//---------------------------------------------------------------------------
#include <qstring.h>
#include <qtextstream.h>
//---------------------------------------------------------------------------
class UserInfo
{
public:
   UserInfo( const QString & sCall );
   ~UserInfo();

   const QString & getName();
   int getFlags();
   int getPwmode();
   const QString & getPwd();
   int getType();
   long getRemotes();
   int getPwAnswer();
   int getPwAnswerLen();
   const QString & getPwCommand();
   const QString & getPwAnswerStr();
   bool getUmbruch();
   int getUmbruchPos();
   int getSwType();
   const QString & getBoxCheck();

   void setName( const QString & sName );
   void setFlags( const int newflags );
   void setPwmode( const int newpwmode );
   void setPwd( const QString & newPwd );
   void setType( const int newtype );
   void setRemotes( const long newremotes );
   void setPWInfos( const int answer, const QString & sCommand, const QString & sAnswStr );
   void setPwAnswerLen( const int len );
   void setUmbruch( const bool _umbruch, const int _umbruchpos );
   void setSwType( const int _swtype );
   void setBoxCheck( const QString & sBoxcheck );

   void writeData();
   bool autoSave;

   void typeChecked( int type, int software );

private:
   // Userdaten
   QString name, call;
   int flags;
   int pwmode;
   QString password;
   int type;
   long remotes;
   int pwanswer;
   int pwanswerlen;
   QString pwcommand;
   QString pwanswerstr;
   bool umbruch;
   int umbruchpos;
   int swtype;
   QString boxCheck;

   void clearData();
   bool readData();
};
//---------------------------------------------------------------------------
#endif
//---------------------------------------------------------------------------

