/* symbols_spkout.h - header file for speakups Audapter driver. */
#define VERSION_AUDPTR 07
#define NUM_STATIC_AUDPTR 7
#define NUM_XTEND_AUDPTR 1
#define NUM_ALIAS_AUDPTR 1 /* ZILCH counts as one, so everything lines up */

/* note the trailing comma... */
#define DEFAULT_STATIC_AUDPTR \
	"\x18", "\x05[f80]", "\x05[r0]", "\x05[s9]", "\x05[g21]",\
	"\x05[f99]", "\x05[f80]",

/* if empty, should *not* have a trailing comma... */
#define DEFAULT_XTEND_AUDPTR \
	  "\x05[An]",

/* required settings and functionality */
#define STATIC_STR_AUDPTR \
	{ "#flush", "\x18", "_", (BUILDER | HARD_DIRECT | NO_USER), { -1 } },\
	{ "pitch", "80", "\x05[f_]", (NUMERIC | HARD_DIRECT | USE_RANGE), "39,4500" }, \
	{ "rate", "0", "\x05[r_]", (NUMERIC | HARD_DIRECT | USE_RANGE), "-100,100" }, \
	{ "tone", "9", "\x05[s_]", (NUMERIC | HARD_DIRECT | USE_RANGE), "0,63" }, \
	{ "volume", "21", "\x05[g_]", (NUMERIC | HARD_DIRECT | USE_RANGE), "0,40" }, \
	{ "caps_start", "\x05[f99]", "_", 0, { '*',-1 } }, \
	{ "caps_stop", "\x05[f80]", "_", 0, { '*',-1 } }

/* additional settings and functionality */
#define XTEND_STR_AUDPTR \
	{ "punct", "n", "\x05[A_]", HARD_DIRECT, "nmsa\xff" }

#define ALIAS_STR_AUDPTR ZILCH
