/********************************
 Chat peer to peer functions
 (c) 1999 Jeremy Wise
 GnomeICU
*********************************/

/*** GnomeICU header files ***/
#include "common.h"

/*** Toplevel header files ***/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/time.h>
#include <fcntl.h>
#include <time.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>
#include <sys/wait.h>
#include <signal.h>
#ifdef HAVE_SOCKS5
#define SOCKS
#include <socks.h>
#endif

GtkWidget *chat_filesel;

/* Global Functions */
int TCPAcceptChat( int sock, GSList *contact, DWORD seq )
{
	BYTE *buffer;
	unsigned short intsize;
	gint chat_sock;
	unsigned short chat_port, backport, tempport;
	gint length = sizeof( struct sockaddr );

	typedef struct
	{
		BYTE uin1[4];
		BYTE version[2];
		BYTE command[2];
		BYTE zero[2];
		BYTE uin2[4];
		BYTE cmd[2];
		BYTE message_length[2];
	} tcp_head;

	typedef struct
	{
		BYTE ip[4];
		BYTE ip_real[4];
		BYTE porta[4];
		BYTE junk;
		BYTE status[4];
		BYTE one[2];
		BYTE zero;
		BYTE back_port[4];
		BYTE portb[4];
		BYTE seq[4];
	} tcp_tail;

	tcp_head pack_head;
	tcp_tail pack_tail;

	struct sockaddr_in my_addr;

	gint cx;
	gboolean have_tcp_port = FALSE;

#ifdef TRACE_FUNCTION
	g_print( "TCPAcceptChat\n" );
#endif

	chat_sock = socket( AF_INET, SOCK_STREAM, 0 );
	if( chat_sock <= 0 )
		return FALSE;

	for( cx = min_tcp_port; cx <= max_tcp_port; cx ++ )
	{
		my_addr.sin_family = AF_INET;
		my_addr.sin_port = g_htons( cx );
		my_addr.sin_addr.s_addr = g_htonl( INADDR_ANY );
		memset(&(my_addr.sin_zero), 0x00, 8 );
	
		if( bind( chat_sock, (struct sockaddr *)&my_addr, sizeof( struct sockaddr ) ) != -1 )
			have_tcp_port = TRUE;
		else
			continue;

		break;
	}

	if( have_tcp_port == FALSE )
		return FALSE;

	listen( chat_sock, 1 );
	((CONTACT_PTR)contact->data)->chat_gdk_input =
		gdk_input_add( chat_sock, GDK_INPUT_READ,
			       (GdkInputFunction) TCPChatHandshake,
			       contact );

	getsockname( chat_sock, ( struct sockaddr * ) &my_addr, &length );
	
	chat_port = g_ntohs( my_addr.sin_port );
	tempport = chat_port;
	backport = ( tempport >> 8 ) + ( tempport << 8 );

	DW_2_Chars( pack_head.uin1, our_info->uin );
	Word_2_Chars( pack_head.version, 0x0003 );
	Word_2_Chars( pack_head.command, ICQ_CMDxTCP_ACK );
	Word_2_Chars( pack_head.zero, 0x0000 );
	DW_2_Chars( pack_head.uin2, our_info->uin );
	DW_2_Chars( pack_head.cmd, ICQ_CMDxTCP_CHAT );
	DW_2_Chars( pack_head.message_length, 1 );

	DW_2_IP( pack_tail.ip, 0x00000000 );
	DW_2_IP( pack_tail.ip_real, LOCALHOST );
	DW_2_Chars( pack_tail.porta, our_port );
	pack_tail.junk = 0x04;
	DW_2_Chars( pack_tail.status, ICQ_ACKxTCP_ONLINE );

	DW_2_Chars( pack_tail.one, 0x0001 );
	pack_tail.zero = 0x00;
	DW_2_Chars( pack_tail.back_port, backport );
	DW_2_Chars( pack_tail.portb, chat_port );
	DW_2_Chars( pack_tail.seq, seq );
	if( sock != -1 )
	{
		intsize = sizeof( tcp_head ) + sizeof( tcp_tail ) + 1;
		buffer = (BYTE*)g_malloc0( intsize + 2 );

		Word_2_Chars (buffer, intsize);
		memcpy( buffer+2, &pack_head, sizeof( pack_head ) );
		buffer[2 + sizeof( pack_head )] = 0x00;
		memcpy( buffer+2 + sizeof( pack_head ) + 1,
		        &pack_tail, sizeof( pack_tail ) );
		write( sock, buffer, intsize + 2 );
		packet_print( buffer+2, intsize,
		              PACKET_TYPE_TCP | PACKET_DIRECTION_SEND, "ACCEPT CHAT" );
		g_free( buffer );
	}
	else
		return -1;

	return 1;
}

int TCPRefuseChat( int sock, DWORD seq )
{
	BYTE *buffer;
	unsigned short intsize;

	typedef struct
	{
		BYTE uin1[4];
		BYTE version[2];
		BYTE command[2];
		BYTE zero[2];
		BYTE uin2[4];
		BYTE cmd[2];
		BYTE message_length[2];
	} tcp_head;

	typedef struct
	{
		BYTE ip[4];
		BYTE ip_real[4];
		BYTE porta[4];
		BYTE junk;
		BYTE status[4];
		BYTE zeroa[4];
		BYTE zerob[4];
		BYTE zeroc[2];
		BYTE zerod;
		BYTE seq[4];
	} tcp_tail;

	tcp_head pack_head;
	tcp_tail pack_tail;

#ifdef TRACE_FUNCTION
	g_print( "TCPRefuseChat\n" );
#endif

	DW_2_Chars( pack_head.uin1, our_info->uin );
	Word_2_Chars( pack_head.version, 0x0003 );
	Word_2_Chars( pack_head.command, ICQ_CMDxTCP_CANCEL );
	Word_2_Chars( pack_head.zero, 0x0000 );
	DW_2_Chars( pack_head.uin2, our_info->uin );
	DW_2_Chars( pack_head.cmd, ICQ_CMDxTCP_CHAT );
	DW_2_Chars( pack_head.message_length, 1 );
	
	DW_2_IP( pack_tail.ip, our_ip );
	DW_2_IP( pack_tail.ip_real, LOCALHOST );
	DW_2_Chars( pack_tail.porta, our_port );
	pack_tail.junk = 0x04;
	DW_2_Chars( pack_tail.status, ICQ_ACKxTCP_REFUSE );

	DW_2_Chars( pack_tail.zeroa, 0x00000001 );
	DW_2_Chars( pack_tail.zerob, 0x00000000 );
	DW_2_Chars( pack_tail.zeroc, 0x00000000 );
	pack_tail.zerod = 0x00;
	DW_2_Chars( pack_tail.seq, seq );

	if( sock != -1 )
	{
		intsize = sizeof( tcp_head ) + sizeof( tcp_tail ) + 1;
		buffer = (BYTE*)g_malloc0( intsize + 2 );

		Word_2_Chars (buffer, intsize);
		memcpy( buffer+2, &pack_head, sizeof( pack_head ) );
		buffer[2 + sizeof( pack_head )] = 0x00;
		memcpy( buffer+2 + sizeof( pack_head ) + 1,
		        &pack_tail, sizeof( pack_tail ) );
		write( sock, buffer, intsize + 2 );
		packet_print( buffer + 2, intsize, 
		              PACKET_TYPE_TCP | PACKET_DIRECTION_SEND, "REFUSE CHAT" );
	}
	else
		return -1;

	return 1;
}

int TCPSendChatRequest( UIN_T uin, gchar *msg )
{
	int sock;
	unsigned short intsize;
	BYTE *buffer;

	typedef struct
	{
		BYTE uin_a[4];
		BYTE version[2];
		BYTE cmd[2];
		BYTE zero[2];
		BYTE uin_b[4];
		BYTE command[2];
		BYTE msg_length[2];
	} tcp_head;

	typedef struct
	{
		BYTE ip[4];
		BYTE real_ip[4];
		BYTE port[4];
		BYTE trail1[4];
		BYTE trail2[4];
		BYTE trail3[4];
		BYTE trail4[4];
		BYTE seq[4];
	} tcp_tail;

	struct
	{
		tcp_head head;
		const gchar *body;
		tcp_tail tail;
	} packet;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "TCPSendChatRequest\n" );
#endif
	rus_conv(RUS_KOI_WIN, msg);
	DW_2_Chars( packet.head.uin_a, our_info->uin );
	Word_2_Chars( packet.head.version, 0x0003 );
	Word_2_Chars( packet.head.cmd, ICQ_CMDxTCP_START );
	Word_2_Chars( packet.head.zero, 0x0000 );
	DW_2_Chars( packet.head.uin_b, our_info->uin );
	Word_2_Chars( packet.head.command, ICQ_CMDxTCP_CHAT );
	Word_2_Chars( packet.head.msg_length, ( strlen( msg ) + 1 ) );

	packet.body = msg;

	DW_2_IP( packet.tail.ip, our_ip );
	DW_2_IP( packet.tail.real_ip, LOCALHOST );
	DW_2_Chars( packet.tail.port, our_port );
	DW_2_Chars( packet.tail.trail1, 0x10000004 );
	DW_2_Chars( packet.tail.trail2, 0x00000100 );
	DW_2_Chars( packet.tail.trail3, 0x00000000 );
	DW_2_Chars( packet.tail.trail4, 0x00000000 );
	DW_2_Chars( packet.tail.seq, seq_num ++ );

	contact = Contacts;
	
	while( contact != NULL )
	{
		if( ((CONTACT_PTR)contact->data)->uin == uin )
			break;
		contact = contact->next;
	}

	if( contact == NULL )
		return 0;

/*** Create packet ***/
	intsize = sizeof( tcp_head ) + sizeof( tcp_tail ) + strlen( msg ) + 1;
	buffer = (BYTE*)g_malloc0( strlen( "REQUEST CHAT" ) + 1 + intsize + 2 );

	Word_2_Chars (buffer, intsize);
	memcpy( buffer+2, &packet.head, sizeof( packet.head ) );
	memcpy( buffer+2 + sizeof( packet.head ), packet.body,
	        strlen( packet.body ) + 1 );
	memcpy( buffer+2 + sizeof( packet.head ) + strlen( packet.body ) + 1,
	        &packet.tail, sizeof( packet.tail ) );
	strcpy( buffer + 2 + intsize, "REQUEST CHAT" );
/*********************/

	((CONTACT_PTR)contact->data)->tcp_msg_queue = g_slist_append( ((CONTACT_PTR)contact->data)->tcp_msg_queue, buffer );

	sock = TCPGainConnection( ((CONTACT_PTR)contact->data)->current_ip, ((CONTACT_PTR)contact->data)->port, contact );

	if( sock == -2 ) /* We're waiting for a connection */
		return TRUE;

	if( sock != -1 )
		TCPClearQueue( contact );
	else
		return -1;

	return 1;
}

int TCPChatSend( GtkWidget *widget, GdkEventKey *ev, int sock )
{
	guchar c;
	char *chat_history_line;
	char tmp[]="_"; 

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "TCPChatSend\n" );
#endif

	contact = Contacts;
	
	while( contact != NULL )
	{
		if( sock == ((CONTACT_PTR)contact->data)->chat_sok )
			break;
		contact = contact->next;
	}

	if( contact == NULL )
		return FALSE;

	if( ev == NULL )
		return FALSE;

	if( ((CONTACT_PTR)contact->data)->oneline_out == NULL )
		((CONTACT_PTR)contact->data)->oneline_out = (char *)g_malloc0( 1024 );

	switch( ev->keyval )
	{
		case GDK_Shift_L:
		case GDK_Shift_R:
		case GDK_Control_L:
		case GDK_Control_R:
		case GDK_Alt_L:
		case GDK_Alt_R:
		case GDK_Up:
		case GDK_Down:
		case GDK_Right:
		case GDK_Left:
		case GDK_Home:
		case GDK_End:
		case GDK_Page_Up:
		case GDK_Page_Down:
		case GDK_Delete:
		case GDK_Caps_Lock:
			return TRUE;
		case 'g':
			if( ev->state & GDK_CONTROL_MASK )
			{
				gnomeicu_event( EV_CHATBEEP , 0 );

				c = 0x07;
			}
			else
				c = ev->keyval;
			break;
		case GDK_Return:
			c = 0x0D;
			break;
		case GDK_BackSpace:
			c = 0x08;
			((CONTACT_PTR)contact->data)->oneline_out[ strlen( ((CONTACT_PTR)contact->data)->oneline_out ) - 1 ] = 0x00;
			break;
		case GDK_Tab:
			c = 0x09;
			break;
		default:
			c = ev->keyval;
	}

	if( c != 0x07 && c != 0x08 && c != 0x09 && c != 0x0D &&
	    strlen( ((CONTACT_PTR)contact->data)->oneline_out ) < 1023 )
	{
		((CONTACT_PTR)contact->data)->oneline_out[ strlen( ((CONTACT_PTR)contact->data)->oneline_out ) + 1 ] = 0x00;
		((CONTACT_PTR)contact->data)->oneline_out[ strlen( ((CONTACT_PTR)contact->data)->oneline_out ) ] = c;
	}

	if( c == 0x0D )
	{
		chat_history_line = (char*)g_malloc0( strlen( our_info->nick ) + strlen( ((CONTACT_PTR)contact->data)->oneline_out ) + 4 );
		sprintf( chat_history_line, "%s> %s\n", our_info->nick, ((CONTACT_PTR)contact->data)->oneline_out );
		((CONTACT_PTR)contact->data)->chat_history = g_slist_append( ((CONTACT_PTR)contact->data)->chat_history, chat_history_line );

		strcpy( ((CONTACT_PTR)contact->data)->oneline_out, "" );
	}
	tmp[0]=c;
	rus_conv(RUS_KOI_WIN, tmp);
	c=tmp[0];
	write( sock, &c, 1 );
	return FALSE;
}

int TCPChatSendSel( GtkWidget *widget, GtkSelectionData *data, guint time, int sock )
{
	char c;
	char *chat_history_line;
	int i = 0;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "TCPChatSendSel\n" );
#endif

	contact = Contacts;
	
	while( contact != NULL )
	{
		if( sock == ((CONTACT_PTR)contact->data)->chat_sok )
			break;
		contact = contact->next;
	}

	if( contact == NULL )
		return FALSE;

	if( data->data == NULL )
		return FALSE;

	c = data->data[ i ];

	while( c != 0x00 )
	{
		switch( c )
		{
			case '\n':
				c = 0x0D;
				break;
		}

		if( c != 0x07 && c != 0x08 && c != 0x09 && c != 0x0D &&
		    strlen( ((CONTACT_PTR)contact->data)->oneline_out ) < 1023 )
		{
			((CONTACT_PTR)contact->data)->oneline_out[ strlen( ((CONTACT_PTR)contact->data)->oneline_out ) + 1 ] = 0x00;
			((CONTACT_PTR)contact->data)->oneline_out[ strlen( ((CONTACT_PTR)contact->data)->oneline_out ) ] = c;
		}

		if( c == 0x0D )
		{
			chat_history_line = (char*)g_malloc0( strlen( our_info->nick ) + strlen( ((CONTACT_PTR)contact->data)->oneline_out ) + 4 );
			sprintf( chat_history_line, "%s> %s\n", our_info->nick, ((CONTACT_PTR)contact->data)->oneline_out );
			((CONTACT_PTR)contact->data)->chat_history = g_slist_append( ((CONTACT_PTR)contact->data)->chat_history, chat_history_line );

			strcpy( ((CONTACT_PTR)contact->data)->oneline_out, "" );
		}

		write( sock, &c, 1 );

		i ++;
		c = data->data[ i ];
	}

	return FALSE;
}

void TCPTerminateChat( GtkWidget *widget, gpointer data )
{
	gint sock = GPOINTER_TO_INT( data );
	char message[ 256 ];

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "TCPTerminateChat\n" );
#endif
	
	contact = Contacts;
	
	while( contact != NULL )
	{
		if( sock == ((CONTACT_PTR)contact->data)->chat_sok )
			break;
		contact = contact->next;
	}
	
	if( contact == NULL )
		return;

	if( ((CONTACT_PTR)contact->data)->chat_gdk_input )
	{
		gdk_input_remove( ((CONTACT_PTR)contact->data)->chat_gdk_input );
		((CONTACT_PTR)contact->data)->chat_gdk_input = 0;
	}
	
	sprintf( message, _("Chat Session terminated:\n%s"), ((CONTACT_PTR)contact->data)->nick );
	gtk_widget_show( gnome_message_box_new( _( message ),
	                                        GNOME_MESSAGE_BOX_INFO,
	                                        GNOME_STOCK_BUTTON_OK, NULL ) );
	close( sock );
	if( ((CONTACT_PTR)contact->data)->chat_file != NULL )
	{
		fclose( ((CONTACT_PTR)contact->data)->chat_file );
		((CONTACT_PTR)contact->data)->chat_file = NULL;
	}
	((CONTACT_PTR)contact->data)->chat_sok = 0;
	((CONTACT_PTR)contact->data)->chat_port = 0;
	((CONTACT_PTR)contact->data)->chat_active = ((CONTACT_PTR)contact->data)->chat_active2 = FALSE;
}

void chat_save( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "chat_save\n" );
#endif

	chat_filesel = gtk_file_selection_new(_("GnomeICU: Save Chat Session"));
	gtk_signal_connect(GTK_OBJECT(chat_filesel), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(chat_filesel)->ok_button), "clicked", GTK_SIGNAL_FUNC(chat_save_got_name), data );
	gtk_signal_connect_object(GTK_OBJECT (GTK_FILE_SELECTION (chat_filesel)->cancel_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT( chat_filesel ) );
	gtk_widget_show(chat_filesel);
}

void chat_save_got_name( GtkWidget *widget, gpointer data )
{
	char *fn;
	int chat_file_fd;
	GSList *list, *contact;
	UIN_T uin = GPOINTER_TO_INT( data );

#ifdef TRACE_FUNCTION
	g_print( "chat_save_got_name\n" );
#endif

	contact = Contacts;

	while( contact != NULL )
	{
		if( uin == ((CONTACT_PTR)contact->data)->uin )
			break;
		contact = contact->next;
	}

	if( contact == NULL )
		return;

	fn = gtk_file_selection_get_filename( GTK_FILE_SELECTION( chat_filesel ) );

	if( ( chat_file_fd = open( fn, O_WRONLY | O_CREAT | O_APPEND, S_IRUSR | S_IWUSR ) ) == -1 )
		return;

	list = ((CONTACT_PTR)contact->data)->chat_history;

	while( list )
	{
		write( chat_file_fd, list->data, strlen( list->data ) );
		list = list->next;
	}
	
	write( chat_file_fd, "\n\n\n", 3 );
	close( chat_file_fd );

	gtk_widget_destroy( chat_filesel );
}

int TCPConnectChat( DWORD port, UIN_T uin )
{
	GtkWidget *textbox;
	DWORD localport;
	struct sockaddr_in local, remote;
	int sizeofSockaddr = sizeof( struct sockaddr );
	int sock;
	DWORD ip;
	unsigned short size;
	BYTE *buffer;

	typedef struct
	{
		BYTE code;
		BYTE version[4];
		BYTE chat_porta[4];
		BYTE uin[4];
		BYTE ip_local[4];
		BYTE ip_remote[4];
		BYTE four;
		BYTE chat_portb[4];
	} handshake_a;

	typedef struct
	{
		BYTE code[4];
		BYTE biga[4];
		BYTE uin[4];
		BYTE name_length[2];
	} handshake_b;
	
	typedef struct
	{
		BYTE revporta;
		BYTE revportb;
		BYTE foreground[4];
		BYTE background[4];
		BYTE zero;
	} handshake_c;

	handshake_a hsa;
	handshake_b hsb;
	handshake_c hsc;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "TCPConnectChat\n" );
#endif

	contact = Contacts;

	while( contact != NULL )
	{
		if( ((CONTACT_PTR)contact->data)->uin == uin )
			break;
		contact = contact->next;
	}

	if( contact == NULL )
		return -1;

	if( ((CONTACT_PTR)contact->data)->chat_sok > 0 )
		return ((CONTACT_PTR)contact->data)->chat_sok;

	ip = ((CONTACT_PTR)contact->data)->current_ip;

	if( ip == 0 )
		return -1;

	sock = socket( AF_INET, SOCK_STREAM, 0 );
	if( sock == -1 )
		return -1;

	fcntl( sock, O_NONBLOCK );

	memset( &local.sin_zero, 0x00, 8 );
	memset( &remote.sin_zero, 0x00, 8 );
	
	local.sin_family = AF_INET;
	remote.sin_family = AF_INET;
	local.sin_port = g_htons( 0 );
	local.sin_addr.s_addr = g_htonl( INADDR_ANY );

	remote.sin_port = g_htons( port );
	remote.sin_addr.s_addr = g_htonl( ip );

	if( connect( sock, (struct sockaddr *)&remote, sizeofSockaddr ) < 0 )
		return -1;

	getsockname( sock, (struct sockaddr*)&local, &sizeofSockaddr );
	localport = g_ntohs( local.sin_port );

	textbox = ChatWindowNew( contact, sock );

	fcntl( sock, O_NONBLOCK );
	((CONTACT_PTR)contact->data)->chat_gdk_input = gdk_input_add( sock, GDK_INPUT_READ, (GdkInputFunction) TCPChatReadServer, textbox );

	((CONTACT_PTR)contact->data)->chat_sok = sock;
	((CONTACT_PTR)contact->data)->chat_port = localport;

	hsa.code = 0xFF;
	DW_2_Chars( hsa.version, 0x00000004 );
	DW_2_Chars( hsa.uin, our_info->uin );
	DW_2_IP( hsa.ip_local, our_ip );
	DW_2_IP( hsa.ip_remote, our_ip );
	hsa.four = 0x04;
	DW_2_Chars( hsa.chat_portb, (DWORD)localport );
	DW_2_Chars( hsa.chat_porta, (DWORD)localport );
	
	size = sizeof( handshake_a );
	buffer = g_malloc0( size + 2 );

	Word_2_Chars (buffer, size);
	memcpy( buffer+2, &hsa, size );
	write( sock, buffer, size + 2 );
	packet_print( buffer+2, size,
	              PACKET_TYPE_TCP | PACKET_DIRECTION_SEND, "CHAT(HSA)" );
	g_free( buffer );
	
	DW_2_Chars( hsb.code, 0x00000064 );
	DW_2_Chars( hsb.biga, 0xFFFFFFFC );
	DW_2_Chars( hsb.uin, our_info->uin );
	Word_2_Chars( hsb.name_length, strlen( our_info->nick ) + 1 );
	hsc.revporta = ((char *)(&localport))[1];
	hsc.revportb = ((char *)(&localport))[0];
	DW_2_Chars( hsc.foreground, 0x00FFFFFF );
	DW_2_Chars( hsc.background, 0x00000000 );
	hsc.zero = 0x00;

	size = sizeof( handshake_b ) + sizeof( handshake_c ) + strlen( our_info->nick ) + 1;
	buffer = (BYTE*)g_malloc0( size + 2 );

	Word_2_Chars (buffer, size);
	memcpy( buffer+2, &hsb, sizeof( handshake_b ) );
	memcpy( buffer + 2 + sizeof( handshake_b ), our_info->nick, strlen( our_info->nick ) + 1 );
	memcpy( buffer + 3 + sizeof( handshake_b ) + strlen( our_info->nick ), &hsc, sizeof( handshake_c ) );
	write( sock, buffer, size + 2 );
	packet_print( buffer+2, size,
	              PACKET_TYPE_TCP | PACKET_DIRECTION_SEND, "CHAT(HSB/C)" );
	g_free( buffer );

	return sock;
}

int TCPChatHandshake( GSList *contact, int sock, GdkInputCondition cond )
{
	GtkWidget *textbox;
	int new_sock;
	int size = sizeof( struct sockaddr );
	struct sockaddr_in their_addr;

#ifdef TRACE_FUNCTION
	g_print( "TCPChatHandshake\n" );
#endif
	
	new_sock = accept( sock, ( struct sockaddr * )&their_addr, &size );
	((CONTACT_PTR)contact->data)->chat_sok = new_sock;
	((CONTACT_PTR)contact->data)->chat_port = g_ntohs( their_addr.sin_port );

	textbox = ChatWindowNew( contact, new_sock );

	if( ((CONTACT_PTR)contact->data)->chat_gdk_input )
		gtk_input_remove( ((CONTACT_PTR)contact->data)->chat_gdk_input );

	fcntl( new_sock, O_NONBLOCK );
	((CONTACT_PTR)contact->data)->chat_gdk_input = gdk_input_add( new_sock, GDK_INPUT_READ, (GdkInputFunction) TCPChatReadClient, textbox );
	return TRUE;
}

int TCPChatReadServer( GtkWidget *widget, int sock, GdkInputCondition cond )
{
	guint16 packet_size;
	BYTE *packet;
	BYTE *buffer;
	BYTE c;
	BYTE zero;
	char tmp[]="_";

	WORD font_length, font_family;
	DWORD font_style;

	char *chat_history_line;

	gchar *font_copy, *font_copy2;
	gchar *font_name;
	WORD font_size = 12;

	char message[256];

	static GtkStyle *style;
	GdkColor *background = NULL;
	GdkColor *foreground = NULL;

	typedef struct
	{
		BYTE version[4];
		BYTE chat_port[4];
		BYTE ip_local[4];
		BYTE ip_remote[4];
		BYTE four;
		BYTE our_port[2];
		BYTE font_size[4];
		BYTE font_face[4];
		BYTE font_length[2];
	} begin_chat_a;
	
	typedef struct
	{
		BYTE one[2];
	} begin_chat_b;

	typedef struct
	{
		DWORD code;
		UIN_T uin;
		WORD name_length;
		BYTE foreground[4];
		BYTE background[4];
		BYTE version[4];
		BYTE chat_port[4];
		BYTE ip_local[4];
		BYTE ip_remote[4];
		BYTE four;
		BYTE our_port[2];
		BYTE font_size[4];
		BYTE font_face[4];
		BYTE font_length[2];
	} read_pak;

	read_pak rpak;
	begin_chat_a paka;
	begin_chat_b pakb;

	GSList *contact = NULL;

#ifdef TRACE_FUNCTION
	g_print( "TCPChatReadServer\n" );
#endif

	font_copy = g_strdup( ChatFontString );
	font_copy2 = font_copy;
	strtok( font_copy2, "-" );
	font_name = strtok( NULL, "-" );

	contact = Contacts;

	while( contact != NULL )
	{
		if( ((CONTACT_PTR)contact->data)->chat_sok == sock )
			break;
		contact = contact->next;
	}

	if( ((CONTACT_PTR)contact->data)->oneline_in == NULL )
		((CONTACT_PTR)contact->data)->oneline_in = (char *)g_malloc0( 1024 );

	if( ((CONTACT_PTR)contact->data)->chat_active == FALSE )
	{
		read( sock, (char*)(&packet_size), 1 );
		read( sock, (char*)(&packet_size) + 1, 1 );
		packet_size = GUINT16_FROM_LE (packet_size);

		packet = (BYTE *)g_malloc0( packet_size );
		read( sock, packet, packet_size );
		packet_print( packet, packet_size,
		              PACKET_TYPE_TCP | PACKET_DIRECTION_RECEIVE, "CHAT(INIT PKT)" );

		rpak.code = Chars_2_DW (packet);
		rpak.uin = Chars_2_DW (packet + 4);

		rpak.name_length = Chars_2_Word (packet + 8);
		/* Read in name here */
		memcpy( &rpak.foreground, ( packet + 10 + GPOINTER_TO_INT( rpak.name_length ) ), 4 );
		memcpy( &rpak.background, ( packet + 14 + GPOINTER_TO_INT( rpak.name_length ) ), 4 );
		((CONTACT_PTR)contact->data)->chat_fg_red = rpak.foreground[0];
		((CONTACT_PTR)contact->data)->chat_fg_green = rpak.foreground[1];
		((CONTACT_PTR)contact->data)->chat_fg_blue = rpak.foreground[2];
		((CONTACT_PTR)contact->data)->chat_bg_red = rpak.background[0];
		((CONTACT_PTR)contact->data)->chat_bg_green = rpak.background[1];
		((CONTACT_PTR)contact->data)->chat_bg_blue = rpak.background[2];

		DW_2_Chars( paka.version, 0x00000004 );
		DW_2_Chars( paka.chat_port, ((CONTACT_PTR)contact->data)->chat_port );
		DW_2_IP( paka.ip_local, our_ip );
		DW_2_IP( paka.ip_remote, our_ip );
		paka.four = 0x04;
		Word_2_Chars( paka.our_port, our_port );
		DW_2_Chars( paka.font_size, font_size );
		DW_2_Chars( paka.font_face, FONT_PLAIN );
		Word_2_Chars( paka.font_length, strlen( font_name ) + 1 );

		Word_2_Chars( pakb.one, 0x4200 );

		packet_size = sizeof( begin_chat_a ) + sizeof( begin_chat_b ) + strlen( font_name ) + 1;
		buffer = (BYTE*)g_malloc0( packet_size );

		Word_2_Chars (buffer, packet_size);
		memcpy( buffer+2, &paka, sizeof( begin_chat_a ) );
		memcpy( buffer+2 + sizeof( begin_chat_a ), font_name, strlen( font_name ) + 1 );
		memcpy( buffer+3 + sizeof( begin_chat_a ) + strlen( font_name ), &pakb, sizeof( begin_chat_b ) );
		write( sock, buffer, packet_size + 2 );
		packet_print( buffer+2, packet_size,
		              PACKET_TYPE_TCP | PACKET_DIRECTION_SEND, "CHAT(BEGIN)" );
		g_free( buffer );

		((CONTACT_PTR)contact->data)->chat_active = TRUE;
	}
	else
	{
		foreground = g_new0( GdkColor, 1 );
		background = g_new0( GdkColor, 1 );
		
		foreground->red = 256 * ((CONTACT_PTR)contact->data)->chat_fg_red;
		foreground->green = 256 * ((CONTACT_PTR)contact->data)->chat_fg_green;
		foreground->blue = 256 * ((CONTACT_PTR)contact->data)->chat_fg_blue;
		foreground->pixel = (gulong)(
		                    ((CONTACT_PTR)contact->data)->chat_fg_red * 65536 +
		                    ((CONTACT_PTR)contact->data)->chat_fg_green * 256 +
		                    ((CONTACT_PTR)contact->data)->chat_fg_blue );
		
		background->red = 256 * ((CONTACT_PTR)contact->data)->chat_bg_red;
		background->green = 256 * ((CONTACT_PTR)contact->data)->chat_bg_green;
		background->blue = 256 * ((CONTACT_PTR)contact->data)->chat_bg_blue;
		background->pixel = (gulong)(
		                    ((CONTACT_PTR)contact->data)->chat_bg_red * 65536 +
		                    ((CONTACT_PTR)contact->data)->chat_bg_green * 256 +
		                    ((CONTACT_PTR)contact->data)->chat_bg_blue );

		gdk_color_alloc( gtk_widget_get_colormap( widget ), foreground );
		gdk_color_alloc( gtk_widget_get_colormap( widget ), background );

		if( style == NULL )
			style = gtk_style_new();
		memcpy( &style->fg[ GTK_STATE_NORMAL ], foreground, sizeof( GdkColor ) );
		memcpy( &style->text[ GTK_STATE_NORMAL ], foreground, sizeof( GdkColor ) );
		memcpy( &style->base[ GTK_STATE_NORMAL ], background, sizeof( GdkColor ) );

		gtk_widget_set_style( widget, style );

		if( ( read( sock, &c, 1 ) ) <= 0 )
		{
			if( ((CONTACT_PTR)contact->data)->chat_gdk_input )
			{
				gdk_input_remove( ((CONTACT_PTR)contact->data)->chat_gdk_input );
				((CONTACT_PTR)contact->data)->chat_gdk_input = 0;
			}
			sprintf( message, _("Chat Session terminated:\n%s"), ((CONTACT_PTR)contact->data)->nick );
			gtk_widget_show( gnome_message_box_new( _( message ),
			                                        GNOME_MESSAGE_BOX_INFO,
			                                        GNOME_STOCK_BUTTON_OK,
			                                        NULL ) );
			close( sock );
			((CONTACT_PTR)contact->data)->chat_sok = 0;
			((CONTACT_PTR)contact->data)->chat_port = 0;
			((CONTACT_PTR)contact->data)->chat_active = ((CONTACT_PTR)contact->data)->chat_active2 = FALSE;
			g_free( foreground );
			g_free( background );
			return TRUE;
		}

		g_free( font_copy );

		if( ChatFont == NULL )
			ChatFont = gdk_font_load( ChatFontString );
		if( ChatFont == NULL )
			ChatFont = gdk_font_load( "-adobe-courier-medium-r-normal-*-*-140-*-*-m-*-iso8859-2" );
		switch( c )
		{
			case 0x00: /* Change foreground color */
				read( sock, &((CONTACT_PTR)contact->data)->chat_fg_red, 1 );
				read( sock, &((CONTACT_PTR)contact->data)->chat_fg_green, 1 );
				read( sock, &((CONTACT_PTR)contact->data)->chat_fg_blue, 1 );
				read( sock, &zero, 1 );
				g_free( foreground );
				g_free( background );
				return FALSE;

			case 0x01: /* Change background color */
				read( sock, &((CONTACT_PTR)contact->data)->chat_bg_red, 1 );
				read( sock, &((CONTACT_PTR)contact->data)->chat_bg_green, 1 );
				read( sock, &((CONTACT_PTR)contact->data)->chat_bg_blue, 1 );
				read( sock, &zero, 1 );
				background->red = 256 * ((CONTACT_PTR)contact->data)->chat_bg_red;
				background->green = 256 * ((CONTACT_PTR)contact->data)->chat_bg_green;
				background->blue = 256 * ((CONTACT_PTR)contact->data)->chat_bg_blue;
				background->pixel = (gulong)(
				                    ((CONTACT_PTR)contact->data)->chat_bg_red * 65536 +
				                    ((CONTACT_PTR)contact->data)->chat_bg_green * 256 +
				                    ((CONTACT_PTR)contact->data)->chat_bg_blue );
				gdk_color_alloc( gtk_widget_get_colormap( ((CONTACT_PTR)contact->data)->chat_remote_text ), background );
				if( style != NULL )
					gtk_style_unref( style );
				style = gtk_style_new();
				style->font = gdk_font_load( ChatFontString );
				if( style->font == NULL )
					style->font = gdk_font_load( "-adobe-courier-medium-r-normal-*-*-140-*-*-m-*-iso8859-2" );

				memcpy( &style->base[ GTK_STATE_NORMAL ], background, sizeof( GdkColor ) );
				gtk_widget_set_style( ((CONTACT_PTR)contact->data)->chat_remote_text, style );
					
				g_free( foreground );
				g_free( background );
				return FALSE;

			case 0x04:
				/* User is away */
				((CONTACT_PTR)contact->data)->chat_away = time(NULL);
				g_free( foreground );
				g_free( background );
				return FALSE;
			case 0x03:
				/* User is back */
				((CONTACT_PTR)contact->data)->chat_away = -1;
				g_free( foreground );
				g_free( background );
				return FALSE;

			case 0x07: /* Beep */
				gnomeicu_event( EV_CHATBEEP , 0 );

				g_free( foreground );
				g_free( background );
				return FALSE;

			case 0x08: /* Backspace */
				((CONTACT_PTR)contact->data)->oneline_in[ strlen( ((CONTACT_PTR)contact->data)->oneline_in ) - 1 ] = 0x00;
				icu_chat_backward_delete( ICU_CHAT( widget ), 1 );
				break;

			case 0x0D: /* CR/LF */
				chat_history_line = (char*)g_malloc0( strlen( ((CONTACT_PTR)contact->data)->nick ) + strlen( ((CONTACT_PTR)contact->data)->oneline_in ) + 4 );
				sprintf( chat_history_line, "%s> %s\n", ((CONTACT_PTR)contact->data)->nick, ((CONTACT_PTR)contact->data)->oneline_in );
				((CONTACT_PTR)contact->data)->chat_history = g_slist_append( ((CONTACT_PTR)contact->data)->chat_history, chat_history_line );

				strcpy( ((CONTACT_PTR)contact->data)->oneline_in, "" );

				icu_chat_insert( ICU_CHAT( widget ), NULL, foreground, background, "\n", 1 );
				break;

			case 0x10: /* Change font */
				read( sock, &font_length, 2 );
				font_length = GINT16_FROM_LE (font_length);
				font_name = (char*)g_malloc0( font_length );
				read( sock, font_name, font_length );
				read( sock, &font_family, 2 );
				font_family = GINT16_FROM_LE (font_family);
				g_free( font_name );
				g_free( foreground );
				g_free( background );
				return FALSE;

			case 0x11: /* Change font style */
				read( sock, &font_style, 4 );
				font_style = GINT32_FROM_LE (font_style);
				g_free( foreground );
				g_free( background );
				return FALSE;

			case 0x12: /* Change font size */
				read( sock, &font_size, 4 );
				font_size = GINT32_FROM_LE (font_size);
				g_free( foreground );
				g_free( background );
				return FALSE;

			default: /* Any other characters */
				if( c != 0x07 && c != 0x08 && c != 0x09 && c != 0x0D &&
	   			 strlen( ((CONTACT_PTR)contact->data)->oneline_in ) < 1023 )
				{
					((CONTACT_PTR)contact->data)->oneline_in[ strlen( ((CONTACT_PTR)contact->data)->oneline_in ) + 1 ] = 0x00;
					((CONTACT_PTR)contact->data)->oneline_in[ strlen( ((CONTACT_PTR)contact->data)->oneline_in ) ] = c;
				}
				
				tmp[0]=c;
				rus_conv(RUS_WIN_KOI, tmp);
				c=tmp[0];

				icu_chat_insert( ICU_CHAT( widget ), ChatFont, foreground, background, &c, 1 );
				break;
		}

		g_free( foreground );
		g_free( background );
	}
	return TRUE;
}

int TCPChatReadClient( GtkWidget *widget, int sock, GdkInputCondition cond )
{
	unsigned short packet_size;
	BYTE *packet;
	BYTE *buffer;
	BYTE c;
	BYTE zero;

	WORD font_length;
	WORD font_family;
	DWORD font_style;

	char *font_copy, *font_copy2;
	char *font_name;
	DWORD font_size = 12;

	char message[256];

	static GtkStyle *style;
	GdkColor *background = NULL;
	GdkColor *foreground = NULL;

	char *chat_history_line;

	typedef struct
	{
		BYTE code[4];
		BYTE uin[4];
		BYTE name_length[2];
	} begin_chat_a;
	
	typedef struct
	{
		BYTE foreground[4];
		BYTE background[4];
		BYTE version[4];
		BYTE chat_port[4];
		BYTE ip_local[4];
		BYTE ip_remote[4];
		BYTE four;
		BYTE our_port[2];
		BYTE font_size[4];
		BYTE font_face[4];
		BYTE font_length[2];
	} begin_chat_b;
	
	typedef struct
	{
		BYTE zeroa[2];
		BYTE zerob;
	} begin_chat_c;

	begin_chat_a paka;
	begin_chat_b pakb;
	begin_chat_c pakc;

	WORD name_length;

	GSList *contact = NULL;

#ifdef TRACE_FUNCTION
	g_print( "TCPChatReadClient\n" );
#endif

	font_copy = (char*)g_malloc0( strlen( ChatFontString ) + 1 );
	strcpy( font_copy, ChatFontString );
	font_copy2 = font_copy;
	strtok( font_copy2, "-" );
	font_name = strtok( NULL, "-" );

	contact = Contacts;

	while( contact != NULL )
	{
		if( ((CONTACT_PTR)contact->data)->chat_sok == sock )
			break;
		contact = contact->next;
	}

	if( contact == NULL )
		return FALSE;

	if( ((CONTACT_PTR)contact->data)->oneline_in == NULL )
		((CONTACT_PTR)contact->data)->oneline_in = (char *)g_malloc0( 1024 );

	if( ((CONTACT_PTR)contact->data)->chat_active == FALSE )
	{
		read( sock, (char*)(&packet_size), 1 );
		read( sock, (char*)(&packet_size) + 1, 1 );
		packet_size = GUINT16_FROM_LE (packet_size);

		packet = (BYTE *)g_malloc0( packet_size );
		read( sock, packet, packet_size );
		packet_print( packet, packet_size,
		              PACKET_TYPE_TCP | PACKET_DIRECTION_RECEIVE, "CHAT(INIT)" );

		if( ((CONTACT_PTR)contact->data)->chat_active2 == TRUE )
		{
			/* Put here interpretation of 0x040000000 packet */
		}

		g_free( packet );
	
		if( ((CONTACT_PTR)contact->data)->chat_active2 == FALSE )
		{
			read( sock, (char*)(&packet_size), 1 );
			read( sock, (char*)(&packet_size) + 1, 1 );
			packet_size = GUINT16_FROM_LE (packet_size);
			if( packet_size < 1024 )
			{
				packet = (BYTE *)g_malloc0( packet_size );
				read( sock, packet, packet_size );
				packet_print( packet, packet_size,
				              PACKET_TYPE_TCP | PACKET_DIRECTION_RECEIVE, "CHAT(INIT)" );

				memcpy( &paka.code, packet, 4 );
				memcpy( &paka.uin, packet + 8, 4 );
				memcpy( &name_length, packet + 12, 2 );
				/* Read in name here */
				memcpy( &pakb.foreground, packet + 16 + GPOINTER_TO_INT( name_length ), 4 );
				memcpy( &pakb.background, packet + 20 + GPOINTER_TO_INT( name_length ), 4 );
				((CONTACT_PTR)contact->data)->chat_fg_red = pakb.foreground[0];
				((CONTACT_PTR)contact->data)->chat_fg_green = pakb.foreground[1];
				((CONTACT_PTR)contact->data)->chat_fg_blue = pakb.foreground[2];
				((CONTACT_PTR)contact->data)->chat_bg_red = pakb.background[0];
				((CONTACT_PTR)contact->data)->chat_bg_green = pakb.background[1];
				((CONTACT_PTR)contact->data)->chat_bg_blue = pakb.background[2];

				g_free( packet );
			}

			DW_2_Chars( paka.code, 0x00000064 );
			DW_2_Chars( paka.uin, our_info->uin );
			Word_2_Chars( paka.name_length, strlen( our_info->nick ) + 1 );
			DW_2_Chars( pakb.foreground, 0x00FFFFFF );
			DW_2_Chars( pakb.background, 0x00000000 );
			DW_2_Chars( pakb.version, 0x00000004 );
			DW_2_Chars( pakb.chat_port, ((CONTACT_PTR)contact->data)->chat_port );
			DW_2_IP( pakb.ip_local, our_ip );
			DW_2_IP( pakb.ip_remote, our_ip );
			pakb.four = 0x04;
			Word_2_Chars( pakb.our_port, our_port );
			DW_2_Chars( pakb.font_size, font_size );
			DW_2_Chars( pakb.font_face, FONT_PLAIN );
			Word_2_Chars( pakb.font_length, strlen( font_name ) + 1 );
			Word_2_Chars( pakc.zeroa, 0x4200 );
			pakc.zerob = 0x00;

			packet_size = sizeof( begin_chat_a ) + sizeof( begin_chat_b ) + sizeof( begin_chat_c ) + strlen( our_info->nick ) + 1 + strlen( font_name ) + 1;
			buffer = (BYTE*)g_malloc0( packet_size + 2 );

			Word_2_Chars (buffer, packet_size);
			memcpy( buffer+2, &paka, sizeof( begin_chat_a ) );
			memcpy( buffer+2 + sizeof( begin_chat_a ), our_info->nick, strlen( our_info->nick ) + 1 );
			memcpy( buffer+3 + sizeof( begin_chat_a ) + strlen( our_info->nick ), &pakb, sizeof( begin_chat_b ) );
			memcpy( buffer+3 + sizeof( begin_chat_a ) + strlen( our_info->nick ) + sizeof( begin_chat_b ), font_name, strlen( font_name ) + 1 );
			memcpy( buffer+4 + sizeof( begin_chat_a ) + strlen( our_info->nick ) + sizeof( begin_chat_b ) + strlen( font_name ), &pakc, sizeof( begin_chat_c ) );
			write( sock, buffer, packet_size + 2 );
			packet_print( buffer+2, packet_size,
			              PACKET_TYPE_TCP | PACKET_DIRECTION_SEND, "CHAT(BEGIN)" );

			g_free( buffer );
			((CONTACT_PTR)contact->data)->chat_active2 = TRUE;
		}
		else
			((CONTACT_PTR)contact->data)->chat_active = TRUE;

		g_free( font_copy );
	}
	else
	{
		g_free( font_copy );

		foreground = (GdkColor *)g_malloc0( sizeof( GdkColor ) );
		background = (GdkColor *)g_malloc0( sizeof( GdkColor ) );
		
		foreground->red = 256 * ((CONTACT_PTR)contact->data)->chat_fg_red;
		foreground->green = 256 * ((CONTACT_PTR)contact->data)->chat_fg_green;
		foreground->blue = 256 * ((CONTACT_PTR)contact->data)->chat_fg_blue;
		foreground->pixel = (gulong)(
		                    ((CONTACT_PTR)contact->data)->chat_fg_red * 65536 +
		                    ((CONTACT_PTR)contact->data)->chat_fg_green * 256 +
		                    ((CONTACT_PTR)contact->data)->chat_fg_blue );
		
		background->red = 256 * ((CONTACT_PTR)contact->data)->chat_bg_red;
		background->green = 256 * ((CONTACT_PTR)contact->data)->chat_bg_green;
		background->blue = 256 * ((CONTACT_PTR)contact->data)->chat_bg_blue;
		background->pixel = (gulong)(
		                    ((CONTACT_PTR)contact->data)->chat_bg_red * 65536 +
		                    ((CONTACT_PTR)contact->data)->chat_bg_green * 256 +
		                    ((CONTACT_PTR)contact->data)->chat_bg_blue );

		gdk_color_alloc( gtk_widget_get_colormap( widget ), foreground );
		gdk_color_alloc( gtk_widget_get_colormap( widget ), background );

		if( style == NULL )
			style = gtk_style_new();
		memcpy( &style->fg[ GTK_STATE_NORMAL ], foreground, sizeof( GdkColor ) );
		memcpy( &style->text[ GTK_STATE_NORMAL ], foreground, sizeof( GdkColor ) );
		memcpy( &style->base[ GTK_STATE_NORMAL ], background, sizeof( GdkColor ) );

		gtk_widget_set_style( widget, style );

		if( ( read( sock, &c, 1 ) ) <= 0 )
		{
			if( ((CONTACT_PTR)contact->data)->chat_gdk_input )
			{
				gdk_input_remove( ((CONTACT_PTR)contact->data)->chat_gdk_input );
				((CONTACT_PTR)contact->data)->chat_gdk_input = 0;
			}
			sprintf( message, "Chat Session terminated:\n%s", ((CONTACT_PTR)contact->data)->nick );
			gtk_widget_show( gnome_message_box_new( _( message ),
			                                        GNOME_MESSAGE_BOX_INFO,
			                                        GNOME_STOCK_BUTTON_OK,
			                                        NULL ) );
			close( sock );
			((CONTACT_PTR)contact->data)->chat_sok = 0;
			((CONTACT_PTR)contact->data)->chat_port = 0;
			((CONTACT_PTR)contact->data)->chat_active = ((CONTACT_PTR)contact->data)->chat_active2 = FALSE;
			g_free( foreground );
			g_free( background );
			return TRUE;
		}

		if( ChatFont == NULL )
			ChatFont = gdk_font_load( ChatFontString );
		switch( c )
		{
			case 0x00: /* Change foreground color */
				read( sock, &((CONTACT_PTR)contact->data)->chat_fg_red, 1 );
				read( sock, &((CONTACT_PTR)contact->data)->chat_fg_green, 1 );
				read( sock, &((CONTACT_PTR)contact->data)->chat_fg_blue, 1 );
				read( sock, &zero, 1 );
				g_free( foreground );
				g_free( background );
				return FALSE;

			case 0x01: /* Change background color */
				read( sock, &((CONTACT_PTR)contact->data)->chat_bg_red, 1 );
				read( sock, &((CONTACT_PTR)contact->data)->chat_bg_green, 1 );
				read( sock, &((CONTACT_PTR)contact->data)->chat_bg_blue, 1 );
				read( sock, &zero, 1 );
				background->red = 256 * ((CONTACT_PTR)contact->data)->chat_bg_red;
				background->green = 256 * ((CONTACT_PTR)contact->data)->chat_bg_green;
				background->blue = 256 * ((CONTACT_PTR)contact->data)->chat_bg_blue;
				background->pixel = (gulong)(
				                    ((CONTACT_PTR)contact->data)->chat_bg_red * 65536 +
				                    ((CONTACT_PTR)contact->data)->chat_bg_green * 256 +
				                    ((CONTACT_PTR)contact->data)->chat_bg_blue );
				gdk_color_alloc( gtk_widget_get_colormap( ((CONTACT_PTR)contact->data)->chat_remote_text ), background );
				if( style != NULL )
					gtk_style_unref( style );
				style = gtk_style_new();
				style->font = gdk_font_load( ChatFontString );
				if( style->font == NULL )
					style->font = gdk_font_load( "-adobe-courier-medium-r-normal-*-*-140-*-*-m-*-iso8859-2" );

				memcpy( &style->base[ GTK_STATE_NORMAL ], background, sizeof( GdkColor ) );
				gtk_widget_set_style( ((CONTACT_PTR)contact->data)->chat_remote_text, style );
					
				g_free( foreground );
				g_free( background );
				return FALSE;

			case 0x04:
				/* User is away */
				((CONTACT_PTR)contact->data)->chat_away = time(NULL);
				g_free( foreground );
				g_free( background );
				return FALSE;

			case 0x03:
				/* User is back */
				((CONTACT_PTR)contact->data)->chat_away = -1;
				g_free( foreground );
				g_free( background );
				return FALSE;

			case 0x07: /* Beep */
				gnomeicu_event( EV_CHATBEEP , 0 );

				g_free( foreground );
				g_free( background );
				return FALSE;

			case 0x08: /* Backspace */
				((CONTACT_PTR)contact->data)->oneline_in[ strlen( ((CONTACT_PTR)contact->data)->oneline_in ) - 1 ] = 0x00;
				icu_chat_backward_delete( ICU_CHAT( widget ), 1 );
				break;

			case 0x0D: /* CR/LF */
				chat_history_line = (char*)g_malloc0( strlen( ((CONTACT_PTR)contact->data)->nick ) + strlen( ((CONTACT_PTR)contact->data)->oneline_in ) + 4 );
				sprintf( chat_history_line, "%s> %s\n", ((CONTACT_PTR)contact->data)->nick, ((CONTACT_PTR)contact->data)->oneline_in );
				((CONTACT_PTR)contact->data)->chat_history = g_slist_append( ((CONTACT_PTR)contact->data)->chat_history, chat_history_line );

				strcpy( ((CONTACT_PTR)contact->data)->oneline_in, "" );

				icu_chat_insert( ICU_CHAT( widget ), NULL, foreground, background, "\n", 1 );
				break;

			case 0x10: /* Change font */
				read( sock, &font_length, 2 );
				font_length = GINT16_FROM_LE (font_length);
				font_name = (char*)g_malloc0( font_length );
				read( sock, font_name, font_length );
				read( sock, &font_family, 2 );
				font_family = GINT16_FROM_LE (font_family);
				g_free( font_name );
				g_free( foreground );
				g_free( background );
				return FALSE;

			case 0x11: /* Change font style */
				read( sock, &font_style, 4 );
				font_style = GINT32_FROM_LE (font_style);
				g_free( foreground );
				g_free( background );
				return FALSE;

			case 0x12: /* Change font size */
				read( sock, &font_size, 4 );
				font_size = GINT32_FROM_LE (font_size);
				g_free( foreground );
				g_free( background );
				return FALSE;

			default: /* Any other characters */
				if( c != 0x07 && c != 0x08 && c != 0x09 && c != 0x0D &&
	   			 strlen( ((CONTACT_PTR)contact->data)->oneline_in ) < 1023 )
				{
					((CONTACT_PTR)contact->data)->oneline_in[ strlen( ((CONTACT_PTR)contact->data)->oneline_in ) + 1 ] = 0x00;
					((CONTACT_PTR)contact->data)->oneline_in[ strlen( ((CONTACT_PTR)contact->data)->oneline_in ) ] = c;
				}

				icu_chat_insert( ICU_CHAT( widget ), ChatFont, foreground, background, &c, 1 );
				break;
		}
	}

	g_free( foreground );
	g_free( background );

	return TRUE;
}

