/*
    libparted
    Copyright (C) 1998-2000  Andrew Clausen  <clausen@gnu.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef PED_FAT_BOOTSECTOR_H
#define PED_FAT_BOOTSECTOR_H

typedef struct _FatBootSector	FatBootSector;
typedef struct _FatInfoSector	FatInfoSector;

#include "fat.h"

#define FAT32_INFO_MAGIC1	0x41615252
#define FAT32_INFO_MAGIC2	0x61417272
#define FAT32_INFO_MAGIC3	0xaa55

/* stolen from mkdosfs, by Dave Hudson */

#define FAT_BOOT_MESSAGE	\
"This partition does not have an operating system loader installed on it.\n\r"\
"Press a key to reboot..."

#define FAT_BOOT_JUMP	"\xeb\x58\x90"		/* jmp	+5a */

#define FAT_BOOT_CODE	"\x0e"			/* push cs */		\
			"\x1f"			/* pop ds */		\
			"\xbe\x74\x7e"		/* mov si, offset message */ \
					/* write_msg_loop: */		\
			"\xac"			/* lodsb */		\
			"\x22\xc0"		/* and al, al */	\
			"\x74\x06"		/* jz done (+8) */	\
			"\xb4\x0e"		/* mov ah, 0x0e */	\
			"\xcd\x10"		/* int 0x10 */		\
			"\xeb\xf5"		/* jmp write_msg_loop */ \
					/* done: */			\
			"\xb4\x00"		/* mov ah, 0x00 */	\
			"\xcd\x16"		/* int 0x16 */		\
			"\xb4\x00"		/* mov ah, 0x00 */	\
			"\xcd\x19"		/* int 0x19 */		\
			"\xeb\xfe"		/* jmp +0 - in case int 0x19 */ \
						/* doesn't work */	\
					/* message: */			\
			FAT_BOOT_MESSAGE

#define FAT_BOOT_CODE_LENGTH 128

struct _FatBootSector {
	__u8	boot_jump[3];	/* 00: Boot strap short or near jump */
	__u8	system_id[8];	/* 03: system name */
	__u16	sector_size;	/* 0b: bytes per logical sector */
	__u8	cluster_size;	/* 0d: sectors/cluster */
	__u16	reserved;	/* 0e: reserved sectors */
	__u8	fats;		/* 10: number of FATs */
	__u16	dir_entries;	/* 11: number of root directory entries */
	__u16	sectors;	/* 13: if 0, total_sect supersedes */
	__u8	media;		/* 15: media code */
	__u16	fat_length;	/* 16: sectors/FAT for FAT12/16 */
	__u16	secs_track;	/* 18: sectors per track */
	__u16	heads;		/* 1a: number of heads */
	__u32	hidden;		/* 1c: hidden sectors (partition start) */
	__u32	sector_count;	/* 20: no. of sectors (if sectors == 0) */

union {
/* FAT16 fields */
struct {
	__u8	drive_num;	/* 24: */
	__u8	empty_1;	/* 25: */
	__u8	ext_signature;	/* 26: always 0x29 */
	__u32	serial_number;	/* 27: */
	__u8	volume_name [11];       /* 2b: */
	__u8	fat_name [8];	/* 37: */

	__u8	boot_code[447];	/* 3f: Boot code (or message) */
} __attribute__ ((packed)) fat16;

/* FAT32 fields */
struct {
	__u32	fat_length;	/* 24: size of FAT in sectors */
	__u16	flags;		/* 28: bit8: fat mirroring, low4: active fat */
	__u16	version;        /* 2a: minor * 256 + major */
	__u32	root_dir_cluster;	/* 2c: */
	__u16	info_sector;    /* 30: */
	__u16	backup_sector;	/* 32: */

	__u8	empty_1 [12];	/* 34: */

	__u16	drive_num;	/* 40: */
	__u8	ext_signature;	/* 42: always 0x29 */
	__u32	serial_number;	/* 43: */
	__u8	volume_name [11];	/* 47: */
	__u8	fat_name [8];	/* 52: */

	__u8	boot_code[420];	/* 5a: Boot code (or message) */
} __attribute ((packed)) fat32;
} u;

	__u16	boot_sign;	/* 1fe: always 0xAA55 */
} __attribute__ ((packed));

struct _FatInfoSector {
	__u32	signature_1;	/* should be 0x41615252 */
	__u8	unused [480];
	__u32	signature_2;	/* should be 0x61417272 */
	__u32	free_clusters;
	__u32	next_cluster;	/* most recently allocated cluster */
	__u8	unused2 [0xe];
	__u16	signature_3;	/* should be 0xaa55 */
} __attribute__ ((packed));

int fat_boot_sector_read (FatBootSector* bs, const PedGeometry* geom);
int fat_boot_sector_analyse (FatBootSector* bs, PedFileSystem* fs);
int fat_boot_sector_set_boot_code (FatBootSector* bs);
int fat_boot_sector_generate (FatBootSector* bs, const PedFileSystem* fs);
int fat_boot_sector_write (const FatBootSector* bs, PedFileSystem* fs);

int fat_info_sector_read (FatInfoSector* is, const PedFileSystem* fs);
int fat_info_sector_generate (FatInfoSector* is, const PedFileSystem* fs);
int fat_info_sector_write (const FatInfoSector* is, PedFileSystem* fs);

#endif /* PED_FAT_BOOTSECTOR_H */

