/* -*- C++ -*- */

/**********************************************************************/
/*   TimeMon (c)  1994  Helmut Maierhofer			                  */
/*   KDE-ified M. Maierhofer 1998                                     */
/*                                                                    */
/*   Ported to KDE 2.0 and other stuff:                               */
/*     Copyright (c) Dirk A. Mueller <dmuell@gmx.net>                 */
/*                                                                    */
/**********************************************************************/

/*
 * confdlg.h
 *
 * Definitions for the timemon configuration dialog.
 */

#ifndef CONFDLG_H
#define CONFDLG_H

#include <qcolor.h>
#include <qcheckbox.h>
#include <qtabdialog.h>
#include <qcombobox.h>

#include <kcolorbtn.h>
#include <klineedit.h>
#include <knuminput.h>

#include "timemon.h"

// -- forward declaration ------------------------------------------------

class KTimeMon;
class QLineEdit;
class QSlider;
class KColorButton;

// -- KConfDialog declaration --------------------------------------------

/*
 * KConfDialog
 */

class KConfDialog : public QTabDialog {

    Q_OBJECT

public:
    KConfDialog(KTimeMon *timemon);
    ~KConfDialog() {}

    void update();		// get values from timemon

  unsigned getInterval() const { return intervalEdit->value(); }
  QColor getKernelColour() const { return kernelCB->color(); }
  QColor getUserColour() const { return userCB->color(); }
  QColor getNiceColour() const { return niceCB->color(); }
  QColor getCachedColour() const { return cachedCB->color(); }
  QColor getUsedColour() const { return usedCB->color(); }
  QColor getBuffersColour() const { return buffersCB->color(); }
  QColor getSwapColour() const { return swapCB->color(); }
  QColor getBgColour() const { return bgCB->color(); }

  bool getAutoScale() const { return autoScaleBox->isChecked(); }
  bool getToolTip() const { return toolTipBox->isChecked(); }
  unsigned getPageScale() const { return pageScaleEdit->value(); }
  unsigned getSwapScale() const { return swapScaleEdit->value(); }
  unsigned getCtxScale() const { return ctxScaleEdit->value(); }

  unsigned getMouseAction(int i) const { return mouseC[i]->currentItem(); }
  const char *getMouseActionCommand(int i) const { return mouseLE[i]->text(); }

private slots:
  void updateSampleWidget(const QColor &); // update colours in configuration
  void toggle(bool state);	// enable/disable scales
  void mouseInteraction(int);	// check mouse interaction

private:

  KTimeMon *timemon;
  KIntNumInput *intervalEdit, *swapScaleEdit, *pageScaleEdit, *ctxScaleEdit;
  QLineEdit *procFileEdit;
  QCheckBox *autoScaleBox, *toolTipBox;
  KColorButton *kernelCB, *userCB, *niceCB;
  KColorButton *buffersCB, *usedCB, *cachedCB;
  KColorButton *swapCB, *bgCB;
  KLineEdit *mouseLE[MAX_MOUSE_ACTIONS];
  QComboBox *mouseC[MAX_MOUSE_ACTIONS];
  bool haveWarned;

  friend class KTimeMon;
};

#endif // CONFDLG_H
