/***********************************************************************
 *
 *  KfindTop.h
 *
 ***********************************************************************/

#ifndef KFINDTOP_H
#define KFINDTOP_H

#include <ktmainwindow.h>
#include <klocale.h>

class QPopupMenu;
class KMenuBar;
class KToolBar;
class KStatusBar;
class Kfind;               
class QPushButton;
class KfindTabDialog;
class KAccel;
class KfOptions;

class KfindTop: public KTMainWindow
{
  Q_OBJECT

public:
  KfindTop(const char *);
  virtual ~KfindTop();
  void menuInit();
  void toolBarInit();
  void nameSetFocus();

public slots:
  void enableSaveResults(bool enable);
  void enableMenuItems(bool enable);
  void keyBindings();
  void prefs();
  void statusChanged(const char *);
  void enableSearchButton(bool);
  void enableStatusBar(bool enable);

  void copySelection();

signals:
  //File Menu
  void open();
  void addToArchive();
  void deleteFile();
  void renameFile();
  void properties();
  void openFolder();
  void saveResults();

  //Edit Menu
  void undo();
  void cut();
  void copy();
  void selectAll();
  void unselectAll();
  void invertSelection();

  //Options Menu
  void keys();

protected:

private:
  KMenuBar       *_mainMenu;
  
  QPopupMenu     *_fileMenu;
  QPopupMenu     *_editMenu;
  QPopupMenu     *_optionMenu;
  
  KToolBar       *_toolBar;
  KStatusBar     *_statusBar;
  Kfind          *_kfind;

  KAccel         *_accel;
  
  KfOptions      *_prefs;
  
  int        fileStart;
  int        fileStop;
  int        openWithM;
  int        toArchM;
  int        deleteM;
  int        renameM;
  int        propsM;
  int        openFldrM;
  int        saveSearchM;
  int        quitM;

  int        editCopy;
  int        editSelectAll;
  int        editUnselectAll;
  int        editInvertSelection;

  int        _width;
};

#endif
