#/* This file implements the user fields tab for kabs editing look.
 *
 * the KDE addressbook
 * copyright:  (C) Mirko Sucker, 1998, 1999, 2000
 * mail to:    Mirko Sucker <mirko@kde.org>
 * requires:   recent C++-compiler, at least Qt 2.0
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.
 
 You should have received a copy of the GNU Library General Public License
 along with this library; see the file COPYING.LIB.  If not, write to
 the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 * $Revision: 1.6 $
 */

#ifndef KAB_LOOK_EDIT_TABUSER_H
#define KAB_LOOK_EDIT_TABUSER_H "$ID$"

#include <look_edit_basictab.h>

class QMultiLineEdit;
class QLabel;
class QGridLayout;
class KabApi;

class TabUser : public TabBasic
{
  Q_OBJECT
public:
  TabUser(KabAPI *, QWidget *parent=0);
  ~TabUser();
  /** Derived from TabBasic. */
  void storeContents(AddressBook::Entry& entry);
  /** Dito. */
  void setContents(const AddressBook::Entry& entry);
  /** Configure this tab according to the file settings. */
  void configure(KabAPI*);
protected:
  enum Fields {
    /* Headline, */
    User1, User2, User3, User4, NoOfFields
  };
  QMultiLineEdit *mledits[NoOfFields];
  QLabel *labels[NoOfFields];
  QString *texts[NoOfFields];
  QCString *keys[NoOfFields];
  QGridLayout *layout;
protected slots:
  void textChangedSlot();
};

#endif // KAB_LOOK_EDIT_TABUSER_H
