/* This file implements the business card look.
 *
 * the KDE addressbook
 * copyright:  (C) Mirko Sucker, 1998, 1999, 2000
 * mail to:    Mirko Sucker <mirko@kde.org>
 * requires:   recent C++-compiler, at least Qt 2.0
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.
 
 You should have received a copy of the GNU Library General Public License
 along with this library; see the file COPYING.LIB.  If not, write to
 the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 * $Revision: 1.4 $
 */

#ifndef LOOK_BUSINESSCARD_H
#define LOOK_BUSINESSCARD_H

// the common interface for looks:
#include "look_basic.h"
#include <kurllabel.h>

class QComboBox;

/** This class implements kabs classical business card look.
 *  Currently, there is no possibility to change the entry in this
 *  view. */
class KABBusinessCard : public KABBasicLook
{
  Q_OBJECT
public:
  /** The constructor. */
  KABBusinessCard(KabAPI*, QWidget* parent=0, const char* name=0);
  /** The virtual destructor. */
  virtual ~KABBusinessCard();
  /** Set the entry. The method is overloaded to fill the combobox
   *  displaying the headlines of the different addresses. */
  void setEntry(const AddressBook::Entry&);
protected:
  /** If tile is true, the card is displayed with a tile background,
    * if it is false, the background color is used. The background
    * color defaults to something.
    */
  bool tile;
  /** The filename of the background image. */
  QCString filename;
  /** The background color. */
  QColor bgColor;
  /** The background tile. */
  QPixmap* background;
  /** The combobox showing the different addresses. */
  QComboBox *addressCombo;
  /** The URL label for displaying the email link. */
  KURLLabel *urlEmail;
  /** The URL label for displaying the homepage link. */
  KURLLabel *urlHome;
  /** The paint event. */
  void paintEvent(QPaintEvent*);
  /** The resize event. */
  void resizeEvent(QResizeEvent*);
  /** The resize event. */
  // void resizeEvent(QResizeEvent*); // currently not handled
  /** The index of the address currently displayed. */
  int currentAddress;
public slots:
  /** Capture clicks on the mail address. */
  void mailURLClicked(const QString&);
  /** Capture clicks on the URL. */
  void homeURLClicked(const QString&);
  /** An address of this entry has been selected. */
  void addressSelected(int);
signals:
  /** The mail URL label has been clicked. */
  // void mailURLActivated(); // moved to look_basic
  /** The home page URL label has been clicked. */
  // void homeURLActivated(); // moved to look_basic
};

#endif // LOOK_BUSINESSCARD_H
