/* -*- C++ -*-
 * This file implements the dialog that is used to edit an entry.
 * 
 * the KDE addressbook
 * copyright:  (C) Mirko Sucker, 1998 1999, 2000
 * mail to:    Mirko Sucker <mirko@kde.org>
 * requires:   recent C++-compiler, at least Qt 2.0
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.
 
 You should have received a copy of the GNU Library General Public License
 along with this library; see the file COPYING.LIB.  If not, write to
 the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 * $Revision: 1.8 $
 */

#ifndef DIALOG_EDIT_ENTRY_H
#define DIALOG_EDIT_ENTRY_H

#include <kdialogbase.h>
#include <klocale.h>
#include "look_edit.h"
#include "kab_topwidget.h"
#include <kdebug.h>

void TopLevelWidget::editEntry()
{
  editCurrentEntry();
}

bool TopLevelWidget::editCurrentEntry()
{
  // it must be ensured that all other changes are committed to the database
  // before calling this method since it uses the entry as it is found into
  // the database
  AddressBook::Entry entry;
  // ----- create a KDialogBase dialog containing a KABEditLook widget:
  KDialogBase dialog(this);
  KABEditLook *look=new KABEditLook(api, &dialog);
  look->setMinimumSize(look->minimumSizeHint());
  dialog.showButtonApply(false);
  dialog.enableButtonSeparator(true);
  dialog.setMainWidget(look);
  // WORK_TO_DO: handle size
  // ----- get the entry:
  if(api->addressbook()->getEntry(*current, entry)!=AddressBook::NoError)
    {
      debug("TopLevelWidget::editCurrentEntry: no such entry.");
    }
  // ----- display the editing dialog:
  look->setEntry(entry);
  if(dialog.exec())
    {
      look->getEntry(entry);
      view->setEntry(entry);
      modified=true;
      hasEmailAddresses=entry.emails.count()>0;
      hasURLs=entry.URLs.count()>0;
      enableButtons();
      emit(setStatus(i18n("Accepted.")));
      return true;
    } else {
      emit(setStatus(i18n("Rejected.")));
      return false;
    }
}


#endif // DIALOG_EDIT_ENTRY_H
