/* 
 *  Copyright (C) 1999-2000 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */

#include <qstringlist.h>
#include <qfile.h>
#include <kglobal.h>
#include <kstddirs.h>
#include <kapp.h>

#include "misc.h"
#include "site.h"


Site::Site()
{
    inputs.setAutoDelete(true);
}


Site::~Site()
{}


QString Site::makeQueryUrl(const QString &query)
{
    QString url = action;
    url += "?";

    QListIterator<InputTag> it(inputs);
    for (; it.current(); ++it)
        {
            url += it.current()->name;
            url += "=";
            
            if (it.current()->user) 
                url += encodeString(query);
            else 
                url += it.current()->value;
            if (!it.atLast()) 
                url += "&";
        }
    return url;
}


Site *SiteFactory::create(const QString &filename)
{
    qDebug("create %s", filename.latin1());
    QFile file(filename);
    if (!file.open(IO_ReadOnly))
        return 0;

    Site *site = newSite();
    QDomDocument doc(&file);
    file.close();
    //    qDebug("Constructed doc");
    QDomElement docel = doc.documentElement();
    site->name = docel.attribute("name");
    qDebug("Name: %s", site->name.latin1());
    site->action = docel.attribute("action");
    qDebug("Action: %s", site->action.latin1());

    QDomElement childel = docel.firstChild().toElement();
    while (!childel.isNull())
        {
            //            qDebug("dom tag: %s", childel.tagName().latin1()); 
            if (childel.tagName() == "input")
                {
                    //                    qDebug("Input");
                    input(site, childel);
                }
            childel = childel.nextSibling().toElement();
        }

    QDomElement interpretel = docel.namedItem("interpret").toElement();
    if (!interpretel.isNull())
        {
            //            qDebug("Interpret");
            interpret(site, interpretel);
        }
    return site;
}


Site *SiteFactory::newSite()
{
    return new Site;
}


void SiteFactory::input(Site *site, const QDomElement &el)
{
    InputTag *tag = new InputTag();
    tag->name = el.attribute("name");
    tag->value = el.attribute("value");
    tag->user = el.attribute("user") == "true" || el.attribute("user") == "TRUE";
    site->inputs.append(tag);
    qDebug("Input name: %s value: %s user: %i",
           tag->name.latin1(), tag->value.latin1(), (int)tag->user);
}


void SiteFactory::interpret(Site *site, const QDomElement &el)
{
    site->resultListStart = el.attribute("resultListStart");
    site->resultItemStart = el.attribute("resultItemStart");
    site->resultListEnd = el.attribute("resultListEnd");
    site->resultItemEnd = el.attribute("resultItemEnd");
    qDebug("resultListStart: %s", site->resultListStart.latin1());
    qDebug("resultListEnd: %s", site->resultListEnd.latin1());
    qDebug("resultItemStart: %s", site->resultItemStart.latin1());
    qDebug("resultItemEnd: %s", site->resultItemEnd.latin1());
}


SiteManager::SiteManager(const QString &sitetype, SiteFactory &factory)
{
#if 0
    KGlobal::dirs()->addResourceType(sitetype,
                                     KStandardDirs::kde_default("data") + "libksearch/" + sitetype + "/");
    QStringList files = KGlobal::dirs()->findAllResources(KStandardDirs::kde_default("data") + "libksearch/" + sitetype);
#endif
    QStringList files = findNewestResources("data", "libksearch/" + sitetype);
    
    dict.setAutoDelete(true);
    for (QStringList::ConstIterator it = files.begin(); it != files.end(); ++it)
        {
            Site *site = factory.create(*it);
            if (site)
                dict.insert(site->name, site);
        }
}
