/* 
 *  Copyright (C) 1999-2000 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#ifndef _PEOPLESEARCH_H_
#define _PEOPLESEARCH_H_


#include <qstringlist.h>
#include "ldapsearchjob.h"
class PeopleSite;
class LdapSiteManager;


class PeopleSiteManager
{
public:
    PeopleSiteManager();
    ~PeopleSiteManager();
    PeopleSite *find(const QString &name);
    QStringList siteList();

private:
    LdapSiteManager *d;
};


class PeopleSearch : public LdapSearchJob
{
    Q_OBJECT
    
public:
    PeopleSearch(PeopleSite *site, const QString &searchtext);

signals:
    void foundItem(const QString &sitename, const QString &name,
                   const QString &email, const QString &phone, const LdapItem &item);
                   
protected:
    virtual void parseItem(const LdapItem &item);
};

#endif 
