#include "dndlistbox.h"
#include <qdragobject.h>
#include <kurl.h>

void KIFDndListBox::dragEnterEvent(QDragEnterEvent *ev)
{
    ev->accept(QUriDrag::canDecode(ev));
}

void KIFDndListBox::dropEvent(QDropEvent *ev)
{
    QStrList fileList;
    bool validUrls = false;
    if(QUriDrag::decode(ev, fileList)){
        QStrListIterator it(fileList);
        for(;it.current(); ++it){
            warning("In dropEvent for %s", it.current());
            KURL url(it.current());
            if(!url.isMalformed()){
                validUrls = true;
                emit urlDropped(it.current());
            }
        }
        if(validUrls)
            emit dropFinished();
    }
}

#include "dndlistbox.moc"

