
#include "debug.h"
#include <kmessagebox.h>
#include <kapp.h>
#include <klocale.h>

void myMessageOutput( QtMsgType type, const char *msg )    
{
  switch ( type )
  {
     case QtDebugMsg:
#ifdef DEBUG
       fprintf( stderr, "Debug: %s\n", msg );
#endif
       break;
     case QtWarningMsg:
       KMessageBox::sorry(0, msg);
       fprintf( stderr, "Warning: %s\n", msg );
       break;
     case QtFatalMsg:
       KMessageBox::error(0, msg);
       fprintf( stderr, "Fatal: %s\n", msg );
       abort();
       // dump core on purpose
  }
}
