#ifndef __KGV_VIEW_H
#define __KGV_VIEW_H

#include <kio/job.h>
#include <kparts/browserextension.h>
#include <klibloader.h>


class KInstance;
class KAction;
class KToggleAction;
class KGVMiniWidget;
class KGVBrowserExtension;

class KGVFactory : public KLibFactory
{
  Q_OBJECT
public:
  KGVFactory();
  virtual ~KGVFactory();

  virtual QObject* create(QObject* parent = 0, const char* name = 0,
                          const char* classname = "QObject",
                          const QStringList &args = QStringList() );

  static KInstance *instance();

private:
  static KInstance *s_instance;
};


class KSelectAction;

class KGVPart: public KParts::ReadOnlyPart
{
  Q_OBJECT
public:
  KGVPart( QWidget *parent = 0, const char *name = 0 );
  virtual ~KGVPart();

  KGVMiniWidget *miniWidget() const { return w; }

protected slots:
  void slotFancy(); 
  void slotOrientation (int);
  void slotMedia (int);
  void slotNewPage ();

protected:
  KToggleAction *fancyAct;
  KSelectAction *orientation, *media;

  // reimplemented from ReadOnlyPart
  virtual bool openFile();
  void enableAllActions( bool enable );

private:
  KGVMiniWidget *w;
  KGVBrowserExtension *m_extension;

  KAction *zoomInAct, *zoomOutAct, *backAct, *forwardAct,
      *startAct, *endAct, *endDocAct, *markAct, *gotoAct;
};

class KGVBrowserExtension : public KParts::BrowserExtension
{
  Q_OBJECT
  friend class KGVPart; // emits our signals
public:
  KGVBrowserExtension( KGVPart *parent );
  virtual ~KGVBrowserExtension() {}

public slots:
  // Automatically detected by konqueror
  void print();

};

#endif


