#ifndef DIALOGS_H
#define DIALOGS_H

#include <qlineedit.h>
#include <qlayout.h>
#include <qcheckbox.h>
#include <kdialogbase.h>
#include <kconfig.h>
#include "types.h"

//-----------------------------------------------------------------------------
class DialogBase : public KDialogBase
{
 Q_OBJECT

 public:
    DialogBase(const QString &caption, int buttonMask,
			   ButtonCode defaultButton,
			   QWidget *parent, const char *name = 0);

 protected:
	QVBoxLayout *top;
};

//-----------------------------------------------------------------------------
class HighScores : public DialogBase
{
 Q_OBJECT
		
 public:
    HighScores(const GameOverItem *, QWidget *parent, const char *name = 0);

	static int betterEntry(const GameOverItem *);

 private slots:
    void reject();
	void writeName();
	
 private:
	int        bEntry;
	QLineEdit *qle;

	static uint nbEntries();
};

//-----------------------------------------------------------------------------
class MultiScores : public DialogBase
{
 public:
	MultiScores(uint nbPlayers, QWidget *parent, const char *name = 0);
	void add(const GameOverItem &);

 private:
	QGridLayout *grid;
	uint         i;
};

//-----------------------------------------------------------------------------
class OptionDialog : public DialogBase
{
 Q_OBJECT

 public:
	OptionDialog(QWidget *parent);

	static bool readMenuVisible();
	static void writeMenuVisible(bool visible);
	static bool readShadow();
	static bool readShowNext();
	static bool readAnimations();

 private slots:
	void accept();

 private:
	QCheckBox *shadow, *next, *anim;

	static KConfig *config();
};

#endif
