#ifndef __SIMPLE_VIEW_H
#define __SIMPLE_VIEW_H

#include <browser.h>
#include <klibloader.h>
#include <qlistbox.h>

class KInstance;

class KSimpleFactory : public KLibFactory
{
  Q_OBJECT
public:
    KSimpleFactory();
    virtual ~KSimpleFactory();
    virtual QObject* create(QObject* parent=0, const char* name=0,
                            const char* classname="QObject",
                            const QStringList &args = QStringList());
    static KInstance *instance();

private:
    static KInstance *s_instance;
};

class KSimpleKonqView: public BrowserView
{
    Q_OBJECT
public:
    KSimpleKonqView();
    virtual ~KSimpleKonqView();
    virtual void openURL(const QString &url, bool reload = false,
                         int xOffset = 0, int yOffset = 0);
    virtual QString url();
    virtual int xOffset();
    virtual int yOffset();
    virtual void stop();
protected slots:
    void slotError(int id, int errorId, const char *errorText);
    void slotFinished(int id);
    void slotRedirection(int id, const char *url);
    void slotData(int id, const char *data, int len);
    void slotClear();
protected:
    virtual void resizeEvent(QResizeEvent *ev);
private:
    QString urlStr;
    int jobId;
    QByteArray dataBuffer;
    QListBox *list;
    KAction *clearAction;
};

#endif
