# Written by David Faure <faure@kde.org>
#!/bin/sh

port=`sed -e 's/,.*//' ~/.kxmlrpcd`
auth=`sed -e 's/.*,//' ~/.kxmlrpcd`

cat > cmd.xml <<EOF
<?xml version="1.0"?>
<methodCall>
	<methodName>KDesktopIface.popupExecuteCommand</methodName>
	<params>
		<param>
			<value>$auth</value>
		</param>
	</params>
</methodCall>
EOF

length=`wc -c cmd.xml | sed -e 's/cmd.xml//;s/ //g'`

cat > head.xml <<EOF
POST /kdesktop HTTP/1.0
Content-Type: text/xml
Content-length: $length

EOF

( echo open localhost $port
  sleep 2
  cat head.xml cmd.xml
  sleep 2
) | telnet -8E
