/*
   - 

  written 1998 by Alexander Budnik <budnik@linserv.jinr.ru>
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
  */

#include "kimap.h"
#include "kconfobjs.h"

//=========================================================
// map configuration
//=========================================================
KiMap::KiMap(const char* nm):name(nm)
{
  KObjectConfig config(KObjectConfig::AppData, name + ".kimap");
  QStrList symList[4], codeList[4];
  config << config.setGroup(confMainGroup)
	 << new KConfigStringObject(confStringLabel, label)
	 << new KConfigStringObject(confStringComment, comment)
	 << new KConfigStringObject(confStringLanguage, language)
	 << new KConfigStringObject(confStringCharset, charset)
	 << new KConfigStringObject(confStringLocale, locale)
	 << new KConfigStrListObject(confStringAuthors , authors);
  unsigned g;for(g=0; g<4; g++) {
    config << config.setGroup(confMapGroups[g])
	   << new KConfigMatchKeysObject(QRegExp("^keysym[0-9]+$"), symList[g])
	   << new KConfigMatchKeysObject(QRegExp("^keycode[0-9]+$"), codeList[g])
	   << new KConfigStrListObject(confStringCaps, capssyms[g]);
  }
  userData = TRUE;
  noFile   = FALSE;
  connect(&config, SIGNAL(noUserDataFile(const char*)),
	  SLOT(noUserDataFile(const char*)));
  connect(&config, SIGNAL(noSystemDataFile(const char*)),
	  SLOT(noSystemDataFile(const char*)));
  config.loadConfig();
  /*--- check information ---*/
  if(comment.isNull() ) comment  = "";
  else {
    if(comment[comment.length()-1] != '.') comment += ".";
  }
  if(language.isNull()) language = i18n("unknown");
  //if(charset.isEmpty()) charset  = "unknown";
  if(label.isEmpty())
    if(!locale.isNull()) label = locale; else label = name;
  if(locale.isEmpty()) locale = i18n("default");
  for(g=0; g<4; g++) {
    /*--- parsing ---*/
    keysyms[g].setAutoDelete(TRUE);
    keycodes[g].setAutoDelete(TRUE);
    capssyms[g].setAutoDelete(TRUE);
    if(g < 1) hasAltKeys = FALSE;
    hasCompose = FALSE;
    if(g > 0 && (symList[g].count() > 0 || codeList[g].count() > 0))
      hasCompose = TRUE;
    if(hasCompose && g > 1 && (symList[g].count() < 1 && codeList[g].count() < 1))
      hasCompose = FALSE;
    if(hasCompose && g > 2 && (symList[g].count() < 1 && codeList[g].count() < 1))
      hasCompose = FALSE;
    /*--- parse key symbols ---*/
    unsigned i;for(i=0; i<symList[g].count(); i++) {
      QStrList *map = new QStrList;
      *map = KObjectConfig::separate(symList[g].at(i));
      keysyms[g].append(map);
      if(g < 1 && !hasAltKeys && map->count() > 3) hasAltKeys = TRUE;
      if(!hasAltKeys && map->count() > 3) hasAltKeys = TRUE;
    }
    /*--- parse key codes ---*/
    for(i=0; i<codeList[g].count(); i++) {
      QStrList *map = new QStrList;
      *map = KObjectConfig::separate(codeList[g].at(i));
      keycodes[g].append(map);
      if(g < 1 && !hasAltKeys && map->count() > 3) hasAltKeys = TRUE;
    }
  }
}
const QString KiMap::Info() const
{
  QStrList authors(this->authors);
  QString com;
  // authors
  if(!authors.count()) com += i18n("Author:  Not specified");
  for(unsigned i = 0; i < authors.count() && i < 4; i++) {
    com += i18n("Author");
    if(authors.count()>1) com += QString("[") + (char)(i+'1') + "]";
    com += QString(":  ") + authors.at(i) + "\n";
  }
  com += "\n";
  // description
  com += i18n("Description:  ") + GoodLabel() + " " 
    + comment + "\n\n";
  // source
  com += i18n("Source:  ");
  com += noFile?i18n("no file")
    :(userData?i18n("user file")
    :i18n("system file"));
  com += " \"" + name + ".kimap\"";
  com += "\n";
  // statistic
  QString num;
  com += i18n("Statistic:  ");
  if(hasCompose) {
    unsigned g, c;
    for (g=c=0; g<4; g++) c += keysyms[g].count();
    num.setNum(c);
  }
  else num.setNum(keysyms[0].count());
  com += num + " ";
  com += i18n("symbols");
  if(hasCompose) {
    unsigned g, c;
    for (g=c=0; g<4; g++) c += keycodes[g].count();
    num.setNum(c);
  }
  else num.setNum(keycodes[0].count());
  com += ", " + num + " ";
  com += i18n("codes");
  if(hasAltKeys) {
    com += ", ";
    com += i18n("alternative symbols");
  }
  return com;
}
const QString KiMap::GoodLabel() const
{
  QString label;
  //CT 18Jan1999 - temporary solution for the inversion thing 
  //      (where "Espagnol idioma" isn't right but "English language" is)
  //  label = language + " " + i18n("language");
  //  if(!charset.isEmpty()) label += ", " + charset + " " + i18n("charset");
  //  return label + ".";
  label = i18n("Language");
  label += ": ";
  label += language;
  label += ". ";
  label += i18n("Charset");
  label += ": ";
  if (charset.isEmpty())
    label += i18n("default");
  else
    label += charset;
  return label + ".";
  //CT don't ask me why the compiler had me to do this lame concatenation
  //   this way. Perhaps because it evaluates from left to right. I could
  //   have used QString::prepend()
}
const QColor KiMap::mapColor() const
{
  return noFile?mapNoFileColor:(userData?mapUserColor:mapNormalColor);
}
const QPixmap KiMap::mapIcon() const
{
  QPainter p;
  QPixmap  pm(21, 14);
  QPixmap  flag(BarIcon(QString("flag_")+locale));

  pm.fill(white);
  p.begin(&pm);
  p.fillRect(0, 0, 20, 13, gray);
  if(!flag.isNull()) p.drawPixmap(0, 0, flag);
  p.setPen(black), p.drawText(0, 0, 20, 13, AlignCenter, label);
  p.end();

  return pm;
}
