/*
 * Copyright (c) 1999 Daniel M. Duley <mosfet@kde.org>
 * Copyright (c) 2000 Matthias Elter <elter@kde.org>
 * Copyright (c) 2000 Rik Hemsley <rik@kde.org>
 *
 * Artistic License - See file LICENSE for details.
 */

#ifndef SERVICE_MENU_H
#define SERVICE_MENU_H

#include <qlist.h>

#include "menus.h"
#include <ksycocaentry.h>

/**
 * PanelServiceMenu is filled with KDE services and service groups. The sycoca
 * database is queried and the hierarchical structure built by creating child
 * menus of type PanelServiceMenu, so the creation is recursive.
 *
 * The entries are sorted alphabetically and groups come before services.
 *
 * @author Rik Hemsley <rik@kde.org>
 */
class PanelServiceMenu : public PanelMenu
{
  Q_OBJECT;

  public:

  PanelServiceMenu(
    const QString & label,
    const QString & relPath,
    QWidget * parent  = 0,
    const char * name = 0
  );

  public slots:
    virtual void initialize();

  protected slots:
    virtual void slotExec(int id);

  protected:

    virtual void mousePressEvent(QMouseEvent *);
    virtual void mouseMoveEvent(QMouseEvent *);

    /**
     * @internal
     */
    class NameAndSycoca
    {
      public:

        NameAndSycoca(const QString &, KSycocaEntry *);

        QString name() const { return name_; }
        KSycocaEntry * entry() const { return entry_; }
        void setId(int id) { id_ = id; }
        int id() const { return id_; }

      private:

        QString name_;
        KSycocaEntry::Ptr entry_;
        int id_;
    };

    /**
     * @internal
     */
    class NameAndSycocaList : public QList<NameAndSycoca>
    {
      public:

        NameAndSycocaList()
          : QList<NameAndSycoca>()
        {
          setAutoDelete(true);
        }

      protected:

        virtual int compareItems(QCollection::Item i1, QCollection::Item i2)
        {
          return strcmp(
            static_cast<NameAndSycoca *>(i1)->name(),
            static_cast<NameAndSycoca *>(i2)->name()
          );
        }
    };

    typedef QListIterator<NameAndSycoca> NameAndSycocaListIterator;

    QString relPath_;
    QPoint mouseDown_;
    NameAndSycocaList serviceList_;

    bool merge_;
    bool loaded_;
};

/**
 * A PanelServiceMenu with extra items added as it's the main K menu.
 *
 * Incorporates quickbrowser, panel options, client menus, etc.
 */
class PanelKMenu : public PanelServiceMenu
{
  Q_OBJECT;

 public:
  PanelKMenu(QWidget *parent=0, const char *name=0);
  ~PanelKMenu();

  virtual void initialize(); // call this before manually adding menus

  int insertClientMenu(KickerClientMenu *p);
  void removeClientMenu(int id);

 protected slots:
  void slotLock();
  void slotLogout();
  void slotRunCommand();
  void slotContextHelp();
  void slotAboutKDE();

 private:
  int client_id;
  KAboutKDE *aboutKDE;
  QIntDict<KickerClientMenu> clients;
};


#endif // SERVICE_MENU_H
