/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <klocale.h>
#include <kglobal.h>
#include <kstddirs.h>
#include <kcmdlineargs.h>
#include <kdebug.h>
#include <kaboutdata.h>
#include <kimageio.h>

#include <stdlib.h>

#include "main.h"
#include "panel.h"
#include "global.h"

KickerApp::KickerApp() : KUniqueApplication()
{
  KGlobal::dirs()->addResourceType("mini", KStandardDirs::kde_default("data") +
                                   "kicker/pics/mini");
  
  KGlobal::dirs()->addResourceType("icon", KStandardDirs::kde_default("data") +
                                   "kicker/pics");

  KGlobal::dirs()->addResourceType("internalapplets", KStandardDirs::kde_default("data") +
                                     "kicker/internalapplets");

  KGlobal::dirs()->addResourceType("tiles", KStandardDirs::kde_default("data") +
                                   "kicker/tiles");
  KImageIO::registerFormats();
  p = new Panel();
  setMainWidget(p);
  p->show();
}

KickerApp::~KickerApp()
{
  delete p;
}

int main( int argc, char ** argv )
{
  KAboutData aboutData( "kicker", I18N_NOOP("The KDE Panel")
                        , "0.1"
                        , I18N_NOOP("The KDE desktop panel.")
                        , KAboutData::License_BSD
                        , "(c) 1999-2000, The KDE Developers");

  aboutData.addAuthor("Matthias Ettrich",0, "ettrich@kde.org");
  aboutData.addAuthor("Daniel M. Duley",0, "mosfet@kde.org");
  aboutData.addAuthor("Matthias Elter",0, "elter@kde.org");
  aboutData.addAuthor("Preston Brown",0, "pbrown@kde.org");
  
  KCmdLineArgs::init( argc, argv, &aboutData );
  // KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  // WABA: Make sure not to enable session management.
  putenv("SESSION_MANAGER=");

  if (!KickerApp::start())
    {
      kdDebug() << "kicker is already running!" << endl;
      return (0);
    }
  
  KickerApp a;
  return a.exec();
}
