/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <qpainter.h>
#include <qdrawutil.h>
#include <qtooltip.h>
#include <kconfig.h>
#include <kwin.h>
#include <kwinmodule.h>
#include <kapp.h>
#include <kglobal.h>
#include <klocale.h>
#include <kprocess.h>
#include <dcopclient.h>
#include <stdio.h>

#include "pagerapplet.h"
#include "pagerapplet.moc"

KWinModule *kwin_module;

extern "C"
{
  InternalApplet* init(QWidget *parent, KWinModule *module)
  {
    kwin_module = module;
	KGlobal::locale()->insertCatalogue("kminipagerapplet");
    return new KMiniPager(parent, "kminipagerapplet");
  }
}

KMiniPagerButton::KMiniPagerButton(int desk, QWidget *parent, const char *name)
  : QButton(parent, name)
{
  deskStr = deskStr.number(desk);
  deskNum = desk;
  connect(this, SIGNAL(clicked()), SLOT(slotClicked()));
}

void KMiniPagerButton::paintEvent(QPaintEvent *)
{
  QPainter p(this);
  p.setFont(font());
  if(!isOn() && !isDown()){
    p.fillRect(rect(), colorGroup().brush(QColorGroup::Dark));
    p.setPen(colorGroup().light());
    p.drawLine(0, 0, width()-1, 0);
    p.drawLine(0, 0, 0, height()-1);
    p.setPen(Qt::black);
    p.drawLine(0, height()-1, width()-1, height()-1);
    p.drawLine(width()-1, 0, width()-1, height()-1);
    p.setPen(Qt::white);
  }
  else{
    p.fillRect(rect(), colorGroup().brush(QColorGroup::Base));
    p.setPen(colorGroup().text());
    p.drawRect(rect());
  }
  p.drawText(0, 0, width(), height(), AlignCenter, deskStr);
}

void KMiniPagerButton::slotClicked()
{
  emit deskChange(deskNum);
}

KMiniPager::KMiniPager(QWidget *parent, const char *name)
  : InternalApplet(parent, name)
{
  curDesk = KWin::currentDesktop();
  layout = 0;
  allocateButtons();
  connect(kwin_module, SIGNAL(desktopChange(int)), SLOT(slotSetDesktop(int)));
  connect(kwin_module, SIGNAL(desktopNumberChange(int)),
          SLOT(slotSetDesktopCount(int)));
  KConfig *config = KGlobal::config();
  config->setGroup("minipager");
  QFont defFont("Helvetica", 10, QFont::Bold);
  defFont = config->readFontEntry("Font", &defFont);
  setFontPropagation(AllChildren);
  setFont(defFont);
}

void KMiniPager::slotSetDesktop(int desktop)
{
  if(KWin::numberOfDesktops() > static_cast<int>(btnList.count()))
    slotSetDesktopCount(desktop);
  btnList[curDesk-1]->setDown(false);
  curDesk = desktop;
  btnList[curDesk-1]->setDown(true);
}

void KMiniPager::slotButtonClicked(int desk)
{
  if(desk == curDesk) // clicked the current desktop
    btnList[curDesk-1]->setDown(true);
  else
    KWin::setCurrentDesktop( desk );
}

int KMiniPager::widthForHeight(int h)
{
  int deskNum = KWin::numberOfDesktops();
  int deskHalf = deskNum/2;

  if(h <= 32)
    return deskNum * h;
  else
    return deskHalf * ((h)/2);
}

int KMiniPager::heightForWidth(int w)
{
  int deskNum = KWin::numberOfDesktops();
  int deskHalf = deskNum/2;

  if(w <= 32)
    return deskNum * w;
  else
    return deskHalf * ((w)/2);
}

void KMiniPager::resizeEvent(QResizeEvent*)
{
  int deskNum = btnList.count();
  int deskHalf = deskNum/2;
  bool horiz = orientation() == Horizontal;
  bool small = (horiz && height() <=32) || (!horiz && width() <=32);
 
  delete layout;

  KMiniPagerButton *btn;

  if(horiz)
    {
      if (small)
        layout = new QGridLayout(this, 1, deskNum);
      else
        layout = new QGridLayout(this, 2, deskHalf);
    }
  else
    {
      if (small)
        layout = new QGridLayout(this, deskNum, 1);
      else
        layout = new QGridLayout(this, deskHalf, 2);
    }
  
  int c = 0, i=0;

  if (small)
    {
      KMiniPagerButton *btn;
      while(c <  deskNum){
        btn = btnList[c];
        if(horiz)
          layout->addWidget(btn, 0, c);
        else
          layout->addWidget(btn, c, 0);
        ++c;
      }
    }
  else
    {
      while(c <  deskHalf){
        btn = btnList[i];
        if(horiz)
          layout->addWidget(btn, 0, c);
        else
          layout->addWidget(btn, c, 0);
        ++i;
        btn = btnList[i];
        if(horiz)
          layout->addWidget(btn, 1, c);
        else
          layout->addWidget(btn, c, 1);
        ++c, ++i;
      }
    }

  layout->activate();
  updateGeometry();

  if(deskNum > 1){
    if(!isVisible())
      show();
  }
  else
    hide();
}

void KMiniPager::allocateButtons()
{
  int i;
  int deskNum = KWin::numberOfDesktops();
  int act = KWin::currentDesktop();
  KMiniPagerButton *btn;
  for(i=1; i <= deskNum; ++i){
    btn = new KMiniPagerButton(i, this);
    btn->setDown(i == act);
    // fix this once kwin supports names
    //QToolTip::add(btn, i18n("Desktop: ") + KWin::desktopName(i));
    QToolTip::add(btn, i18n("Desktop: ") + QString::number(i));

    btnList.append(btn);
    connect(btn, SIGNAL(deskChange(int)), SLOT(slotButtonClicked(int)));
  }
}

void KMiniPager::slotSetDesktopCount(int)
{
  QValueList<KMiniPagerButton*>::Iterator it;
  for(it=btnList.begin(); it != btnList.end(); ++it)
    delete (*it);
  btnList.clear();
  allocateButtons();
  curDesk = KWin::currentDesktop();
  resizeEvent(0);
  updateLayout();
}
