/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef APPLETS_H
#define APPLETS_H

#include "../../internalapplet.h"

#include <qlist.h>
#include <qxembed.h>

// Hacky class that is the same as QXEmbed, but does not destroy its
// window in the destructor. It would be nice if Qt would have support 
// for this.

class KXEmbed: public QXEmbed
{
public:
    KXEmbed(QWidget *parent=0L, const char *name=0L, WFlags f=0);
    ~KXEmbed();
};


class DockAreaApplet : public InternalApplet
{
    Q_OBJECT
public:

    DockAreaApplet( QWidget* parent, const char* name = 0 );
    ~DockAreaApplet();

    int widthForHeight(int h);
    int heightForWidth(int w);

protected:
    void resizeEvent( QResizeEvent* );
    void paintEvent( QPaintEvent* );

private slots:
    void dockWindowAdd( WId );
    void updateDockWindows();
    void layoutDockingArea();

private:

    QList<KXEmbed> m_Docks;
};

#endif
