/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <qpainter.h>
#include <qlineedit.h>

#include <kapp.h>
#include <kmessagebox.h>
#include <kglobal.h>
#include <klocale.h>

#include "example.h"
#include "example.moc"

#define H_STRING "I'm a horizontal applet"
#define V_STRING "I'm a vertical applet"

ExampleApplet::ExampleApplet( QWidget* parent, const char* name )
  : KPanelApplet( parent, name )
{
  lined = new QLineEdit( this );
  lined->setText("edit me");
  setFont( QFont("times-24") );

  //setFlags(KPanelApplet::Stretch);
  setActions(About | Help | Preferences);
}

ExampleApplet::~ExampleApplet() {}

void ExampleApplet::about()
{
  KMessageBox::information(0, i18n("I'm a example applet I do not have a about dialog."));
}

void ExampleApplet::help()
{
  KMessageBox::information(0, i18n("I'm a example applet. There is no help available."));
}

void ExampleApplet::preferences()
{
  KMessageBox::information(0, i18n("I'm a example applet I do not have a preferences dialog."));
}

int ExampleApplet::widthForHeight(int )
{
  QFontMetrics fm( fontMetrics() );
  return fm.width(H_STRING) + 10;
}

int ExampleApplet::heightForWidth(int )
{
  QFontMetrics fm( fontMetrics() );
  return fm.width( V_STRING ) + 20 +10;
}

void ExampleApplet::resizeEvent( QResizeEvent* )
{
  lined->setGeometry( 0, 0, width(), 20 );
}

void ExampleApplet::paintEvent( QPaintEvent* )
{
  QPainter p( this );
  if ( orientation() == Vertical ) {
	p.saveWorldMatrix();
	p.translate( rect().center().x(), 20 );
	p.rotate( 90 );
	p.drawText( 0, 0, V_STRING );
	p.restoreWorldMatrix();
  } else {
	p.drawText( 0, 20 + fontMetrics().ascent(), H_STRING );
  }
}
