#!/bin/sh
# /etc/init.d/@initd_kdm@: start or stop the X display manager

set -e

PATH=/bin:/usr/bin:/sbin:/usr/sbin
DAEMON=@kde_bindir@/kdm
PIDFILE=/var/run/@kdm_package@.pid

test -x $DAEMON || exit 0

case "$1" in
  start)
      problem=yes
      echo -n "Checking for valid XFree86 server configuration..."
      if [ -e /etc/X11/XF86Config ]; then
        problem=
      else
        echo "file not found."
      fi
      if [ "$problem" ]; then
        echo "Not starting X display manager."
        exit 1
      else
        echo "done."
      fi
    echo -n "Starting X display manager: kdm"
    start-stop-daemon --start --quiet --pid $PIDFILE --exec $DAEMON || echo -n " already running"
    echo "."
  ;;

  restart)
    /etc/init.d/@initd_kdm@ stop
    /etc/init.d/@initd_kdm@ start
  ;;

  reload)
    echo -n "Reloading X display manager configuration..."
    if start-stop-daemon --stop --signal 1 --quiet --pid $PIDFILE --exec $DAEMON; then
      echo "done."
    else
      echo "kdm not running."
    fi
  ;;

  force-reload)
    /etc/init.d/@initd_kdm@ reload
  ;;

  stop)
    echo -n "Stopping X display manager: kdm"
    start-stop-daemon --stop --quiet --pid $PIDFILE --exec $DAEMON || echo -n " not running"
    echo "."
  ;;

  *)
    echo "Usage: /etc/init.d/@initd_kdm@ {start|stop|restart|reload|force-reload}"
    exit 1
    ;;
esac

exit 0
