/***************************************************************************
                          IOCore.h  -  description
                             -------------------
    begin                : Sun Oct 3 1999
    copyright            : (C) 1997-99 by Peter Putzer
    email                : putzer@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2.                              *
 *                                                                         *
 ***************************************************************************/

#ifndef KSV_IOCORE_H
#define KSV_IOCORE_H

#pragma interface

#include <qdir.h>
#include <qstring.h>

// forward declerations
class QFileInfo;
class KSVData;

class IOCore
{
  /** 
    * static members (utility functions)
    */
 public:
  static QString removeFile( const QFileInfo* info, QDir dir );
  static QString relToAbs( QString dir, QString rel );
  static QString makeSymlink (const KSVData& data, int runlevel, bool start);
  static void dissectFilename( QString _file, QString& _name, int& _nr );
  static bool copyFile (QString file1, QString file2);
  static QString makeRelativePath (QString from, QString to);
};

#endif

