/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include "ioaddress.h"


IOAddress::IOAddress(ulong ioval, ulong range, int index) : Resource(ioval, 1, index)

{
  setResourceRange(range);
}


/*
 * Public methods
 *****************/
 
bool  IOAddress::operator==(const IOAddress& ioaddr) const
{
  // return ((_resval == ioaddr.resourceValue()) && (_resrng == ioaddr.resourceRange()));
  return (_resval == ioaddr.resourceValue());
}

QString IOAddress::resourceLowerName() const
{
  return i18n("I/O area");
}

QString IOAddress::resourceUpperName() const{
  return i18n("I/O area");
}
