//////////////////////////////////////////////////////////////         
//      $Id: procbuf.cpp,v 1.11 2000/06/07 15:39:03 toivo Exp $ 
//
// Author: Toivo Pedaste
//
#include "../config.h"
#include "procbuf.h"
#include <kprocess.h>
#include "kpackage.h"
#include <klocale.h>

Modal::Modal(QString msg, QWidget *parent, QString name )
  : QDialog( parent, name, TRUE )
{
  QLabel *line1 = new QLabel(msg,this);
  line1->setAlignment(AlignCenter);
  line1->setAutoResize(true);

 }

void Modal::terminate()
{
  done(0);
}

procbuf::procbuf()
{
  m = NULL;
}

procbuf::~procbuf()
{
}

void procbuf::setup(QString cmd)
{
  buf.truncate(0);
  proc = new KProcess();
  connect(proc, SIGNAL( receivedStdout(KProcess *, char *, int)), 
			this, SLOT(slotReadInfo(KProcess *, char *, int)));
  connect(proc, SIGNAL( receivedStderr(KProcess *, char *, int)), 
			this, SLOT(slotReadInfo(KProcess *, char *, int)));
  connect(proc, SIGNAL( processExited(KProcess *)), 
			this, SLOT(slotExited(KProcess *)));
  proc->clearArguments();
  *proc << cmd;
  command = cmd;
}

void procbuf::slotReadInfo(KProcess *, char *buffer, int buflen)
{
   char last;

   last = buffer[buflen - 1];
   buffer[buflen - 1] = 0;
   buf += buffer;
   buf += last;
}

void procbuf::slotExited(KProcess *)
{
  delete proc;
  if (m) {
    m->terminate();
  }
}

int procbuf::start (QString msg, bool errorDlg )
{
  if (msg.isEmpty())
    msg = i18n("Wait %1").arg(command);
 
  if (!proc->start(msg ? KProcess::NotifyOnExit : KProcess::Block,
		   KProcess::AllOutput)) {
    KpMsgE(i18n("Kprocess Failure"),TRUE);
    return 0;
  };

  proc->closeStdin();
  if (!msg.isEmpty()) {
    m = new Modal(msg,kpkg,i18n("Wait"));
    m->exec();
    delete m;
    m = NULL;
  }

  kdDebug() << command 
	    << " dialog=" << errorDlg 
	    << " normal=" << proc->normalExit()
	    << " exit=" << proc->exitStatus() << endl;

  if (!proc->normalExit() || proc->exitStatus()) {
    if (errorDlg) {
      if (buf.length()) {
	KpMsg("Error",i18n("Kprocess error:%1").arg(buf), TRUE);
      } else {
	KpMsg("Error",i18n("Kprocess error: Can't start %1").arg(command), TRUE);
      }
    }
    return 0;
  }

  return 1;
}











