/*
    KTop, the KDE Task Manager
   
	Copyright (c) 1999 Chris Schlaeger <cs@kde.org>
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

	KTop is currently maintained by Chris Schlaeger <cs@kde.org>. Please do
	not commit any changes without consulting me first. Thanks!

	$Id: SensorManager.cc,v 1.3 1999/12/26 19:10:24 cschlaeg Exp $
*/

#include "SensorManager.h"
#include "SensorAgent.h"
#include "SensorManager.moc"

SensorManager* SensorMgr;

SensorManager::SensorManager()
{
	sensors.setAutoDelete(true);
}

SensorManager::~SensorManager()
{
}

SensorAgent*
SensorManager::engage(const QString& hostname)
{
	SensorAgent* ktopd;

	if ((ktopd = sensors.find(hostname)) == 0)
	{
		ktopd = new SensorAgent;
		ktopd->start(hostname.ascii(), "rsh");
		sensors.insert(hostname, ktopd);
		emit update();
	}
	return (ktopd);
}

void
SensorManager::disengage(const SensorAgent* sa)
{
	QDictIterator<SensorAgent> it(sensors);
	
	while (it.current())
		if (it.current() == sa)
			sensors.remove(it.currentKey());
}

const QString
SensorManager::getHostName(const SensorAgent* sensor) const
{
	static QString dummy;

	QDictIterator<SensorAgent> it(sensors);
	
	while (it.current())
		if (it.current() == sensor)
			return (it.currentKey());

	return (dummy);
}
