/* This file implements the tab to edit contact information.
 *
 * the KDE addressbook
 * copyright:  (C) Mirko Sucker, 1998, 1999, 2000
 * mail to:    Mirko Sucker <mirko@kde.org>
 * requires:   recent C++-compiler, at least Qt 2.0
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.
 
 You should have received a copy of the GNU Library General Public License
 along with this library; see the file COPYING.LIB.  If not, write to
 the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 * $Revision: 1.1 $
 */

#include "look_edit_tabcontact.h"
#include <qpushbutton.h>
#include <qlayout.h>
#include <kmessagebox.h>
#include <klocale.h>

TabContact::TabContact(QWidget *parent)
  : TabBasic(parent)
{
  const QString Texts[] = {
    i18n("Edit email addresses"),
    i18n("Edit talk addresses"),
    i18n("Edit URLs (internet addresses)"),
    i18n("Edit telephone numbers")
  };
  QPushButton ** buttons[] = {
    &buttonEmail, &buttonTalk, &buttonURLs, &buttonTelephone
  };
  const int Size=sizeof(Texts)/sizeof(Texts[0]);
  int count;
  // -----
  layout=new QGridLayout(this, 4, 1, 3, 2);
  if(layout==0)
    {
      KMessageBox::sorry
	(this, i18n("Out of memory."),
	 i18n("General failure."));
      ::exit(-1);
    } 
  layout->setAutoAdd(true);
  for(count=0; count<Size; ++count)
    {
      *buttons[count]=new QPushButton(Texts[count], this);
    }
  connect(buttonEmail, SIGNAL(clicked()), SLOT(editEmailAddresses()));
  connect(buttonTalk, SIGNAL(clicked()), SLOT(editTalkAddresses()));
  connect(buttonURLs, SIGNAL(clicked()), SLOT(editURLs()));
  connect(buttonTelephone, SIGNAL(clicked()), SLOT(editTelephoneNumbers()));
}

void TabContact::storeContents(AddressBook::Entry& e)
{
  e.emails=entry.emails;
  e.talk=entry.talk;
  e.URLs=entry.URLs;
  e.telephone=entry.telephone;
}

void TabContact::setContents(const AddressBook::Entry& e)
{
  entry=e;
}

void TabContact::editEmailAddresses()
{
  debug("TabContact::editEmailAddresses");
}

void TabContact::editTalkAddresses()
{
  debug("TabContact::editTalkAddresses");
}

void TabContact::editURLs()
{
  debug("TabContact::editURLs");
}

void TabContact::editTelephoneNumbers()
{
  debug("TabContact::editTelephoneNumbers");
}
