/* This file implements the base class for kabs looks..
 *
 * the KDE addressbook
 * copyright:  (C) Mirko Sucker, 1998, 1999, 2000
 * mail to:    Mirko Sucker <mirko@kde.org>
 * requires:   recent C++-compiler, at least Qt 2.0
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.
 
 You should have received a copy of the GNU Library General Public License
 along with this library; see the file COPYING.LIB.  If not, write to
 the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 * $Revision: 1.4 $
 */

#include "look_basic.h"


KABBasicLook::KABBasicLook(KabAPI* api, QWidget* parent, const char* name)
  : QWidget(parent, name)
{
  db=api;
}

void
KABBasicLook::setEntry(const AddressBook::Entry& e)
{
  current=e;
  repaint(false); // ??? avoid flickering?
}

void
KABBasicLook::getEntry(AddressBook::Entry& entry)
{
  entry=current;
}

