/* -*- C++ -*-
 * This file implements the method to create new addressbook files..
 * 
 * the KDE addressbook
 * copyright:  (C) Mirko Sucker, 1998 1999, 2000
 * mail to:    Mirko Sucker <mirko@kde.org>
 * requires:   recent C++-compiler, at least Qt 2.0
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.
 
 You should have received a copy of the GNU Library General Public License
 along with this library; see the file COPYING.LIB.  If not, write to
 the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 * $Revision: 1.7 $
 */

#include <kabapi.h>
#include <kfiledialog.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <qfileinfo.h>
#include <qstring.h>
#include <qdir.h>
#include <kapp.h>
#include <kdebug.h>
#include <kurl.h>
#include "kab_topwidget.h"

void TopLevelWidget::createNew()
{
  register bool GUARD; GUARD=true;
  // ###########################################################################
  kDebugInfo(GUARD, 0, "KabMainWindow::newFile: called.");
  QString home, filename;
  KURL dummy;
  QFileInfo info;
  // ----- select the filename:
  home=QDir::homeDirPath();
  if(home.isEmpty())
    {
      KMessageBox::sorry
	(this, i18n("Could not find the users home directory."), i18n("Sorry"));
      setStatus(i18n("Intern error!")); 
      kapp->beep();
      return;
    }
  for(;;) // do forever
    {
      // dummy=KFileDialog::getOpenFileName(home, "*kab", this);
      dummy=KFileDialog::getOpenURL(home, "*kab", this);
      kDebugInfo(GUARD, 0, "KabMainWindow::newFile: URL is %s.", dummy.decodedURL().data());
      if(dummy.isEmpty()) // dialog has been cancelled
	{
	  setStatus(i18n("Cancelled."));
	  qApp->beep();
	  return;
	}
      // WORK_TO_DO: download the URL or find the local file name in filename
      if(!dummy.isLocalFile())
      {
        setStatus( i18n( "Only local files supported yet." ) );
	qApp->beep();
	return;
      } else {
	filename=dummy.path();
      }
      // ...
      // -----
      info.setFile(filename);
      if(info.isDir() || info.exists())
	{
	  KMessageBox::sorry
	    (this, 
	     i18n("This file is a directory, or it already exists.\n"
		  "Please select another filename.\n"
		  "You must have permission to write "
		  "to create the new file."),
	     i18n("File error"));
	} else {
	  kDebugInfo(GUARD, 0, "KabMainWindow::newFile: filename is %s.", filename.data());
	  break;
	}
    }
  // ----- adjust name:
  if(filename.length()<4 || filename.mid(filename.length()-4, 4)!=".kab")
    {
      filename+=".kab";
      KMessageBox::information
	(this,
	 i18n("The filename did not end with \".kab\".\n"
	      "It has been changed to\n")+filename,
	 i18n("Note"));
    }
  // ----- create the new database file:
  if(api->addressbook()->createNew(filename)!=AddressBook::NoError)
    {
      KMessageBox::sorry
	(this,
	 i18n("The file could not be created, possibly permission denied."),
	 i18n("kab: File error"));
      qApp->beep();
      return;
    }
  // ----- load this file:
  if(api->addressbook()->load(filename)!=AddressBook::NoError)
    {
      KMessageBox::sorry
	(this, i18n("The file has been created, but could not be loaded."),
	 i18n("File error"));
      qApp->beep();
      return;
    }
  // -----
  kDebugInfo(GUARD, 0, "KabMainWindow::newFile: done.");  
  // ###########################################################################
}

