#include <stdio.h>

#include <qevent.h>

#include <kapp.h>
#include <klocale.h>
#include <kmenubar.h>
#include <kaboutdata.h>
#include <kfiledialog.h>
#include <kmessagebox.h>
#include <kcmdlineargs.h>

#include "icontool.h"
#include "icontool.moc"

static const char *description = 
	I18N_NOOP("KDE Icon Package tool");

static const char *version = "v0.0.1";


IconTool::IconTool(const char * name)
  : KTMainWindow(name)
{
  mymenu=new KMenuBar(this);
  QPopupMenu * thepopup=new QPopupMenu;
  thepopup->insertItem(i18n("&New"),this,SLOT(file_new()));
  thepopup->insertItem(i18n("&Open..."),this,SLOT(file_open()));
  thepopup->insertItem(i18n("&Save..."),this,SLOT(file_save()));
  thepopup->insertItem(i18n("&Quit"),this,SLOT(file_quit()));
  //this->setPopupMenu(thepopup);
  mymenu->insertItem(i18n("&File"),thepopup);
  mymenu->show();
  myview=new IconView(this);
  myview->show();
  havename=false;
  thename="";
}

IconTool::~IconTool()
{
}

void IconTool::file_new()
{
  myview->do_new();
}

void IconTool::file_open()
{
  KURL url = KFileDialog::getOpenURL(QString::null,"*.ind");

  if( url.isEmpty() )
    return;

  if( !url.isLocalFile() )
  {
    KMessageBox::sorry( 0L, i18n( "Only local files supported yet." ) );
  }

  QString sn = url.path();
  
  int i;
  i=sn.find('.');
  if(i>-1) {
    sn=sn.left(i);
  }
  myview->load_index(sn);  
}

void IconTool::file_save()
{
  KURL url = KFileDialog::getSaveURL(QString::null,"*.ind");

  if( url.isEmpty() )
    return;

  if( !url.isLocalFile() )
  {
    KMessageBox::sorry( 0L, i18n( "Only local files supported yet." ) );
  }

  QString sn = url.path();
  
  int i;
  i=sn.find('.');
  if(i>-1) {
    sn=sn.left(i);
  }
  myview->save(sn);  
}

void IconTool::file_quit()
{
  qApp->quit();
}

void IconTool::resizeEvent(QResizeEvent *)
{
  myview->setGeometry(0,mymenu->height(),width(),height()-
                      mymenu->height());
  myview->updateSize();
}

int main(int argc,char ** argv)
{
  KAboutData aboutData("iconpackager", I18N_NOOP("IconTool"),
    version, description, KAboutData::License_GPL,
    "(c) Unknown KDE Developers");
//  aboutData.addAuthor("",0, "");
  KCmdLineArgs::init( argc, argv, &aboutData );

  KApplication app;
  IconTool *icontool=new IconTool("Icontool");
  icontool->show();
  return app.exec();
}
