/* 
   This file is part of libodbc++.
   
   Copyright (C) 1999 Manush Dodunekov <manush@litecom.net>
   
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef __ODBCXX_SETUP_H
#define __ODBCXX_SETUP_H

#if !defined(WIN32)
# include <odbc++/config.h>
#else
# include <odbc++/config-win32.h>
#endif


#if defined(ODBCXX_ENABLE_THREADS)
# if !defined(_REENTRANT)
#  define _REENTRANT 1
# endif
# if !defined(_THREAD_SAFE)
#  define _THREAD_SAFE 1
# endif
#endif

// check if ODBCVER is forced to something
#if defined(ODBCXX_ODBCVER)
# define ODBCVER ODBCXX_ODBCVER
#endif

// this can confuse our Types::CHAR
#ifdef CHAR
#undef CHAR
#endif

// NDEBUG and cassert
#if defined(IN_ODBCXX) 
# if !defined(ODBCXX_DEBUG)
#  define NDEBUG
# endif
# include <cassert>
#endif


#if defined(_MSC_VER) || defined(__BORLANDC__)
# if defined(ODBCXX_DLL)
#  if defined(IN_ODBCXX)
#   define ODBCXX_EXPORT __declspec(dllexport)
#  else
#   define ODBCXX_EXPORT __declspec(dllimport)
#  endif
# endif
#endif

#if !defined(ODBCXX_EXPORT)
# define ODBCXX_EXPORT
#endif

#if defined(_MSC_VER)
# define ODBCXX_DUMMY_RETURN(x) return (x)
#else
# define ODBCXX_DUMMY_RETURN(x) ((void)0)
#endif


#endif // __ODBCXX_SETUP_H
