#include <klocale.h>
#include "main.h"
#include "tl_board.h"
#include "tl_piece.h"
#include "tl_ai.h"
#include "lib/mp_interface.h"
#include "version.h"

const MPGameInfo TL_GAME_INFO = {
        TL_MULTIPLAYER_ID,
        4,     // max nb local games
        500,   // interval
        TRUE,  // IA allowed
        0, 0   // no setting slots
};

const MPGameInfo &gameInfo()
{
	return TL_GAME_INFO;
}

Board *createBoard(QWidget *parent)
{
	return new TLBoard(TRUE, parent);
}

GPieceInfo *createPieceInfo()
{
	return new TLPieceInfo;
}

AI *createAI()
{
	return  new TLAI(0, 10); // times need tuning ?
}

static const char *TL_DESCRIPTION =
    I18N_NOOP("KSirtet is a clone of the well-known Tetris game.");
			
int main(int argc, char **argv)
{
	return generic_main(argc, argv, "ksirtet", I18N_NOOP("KSirtet"),
						TL_DESCRIPTION, FALSE);
}
