/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "buttonbar.h"
#include "buttonbar.moc"
#include "global.h"

#include <qdrawutil.h>
#include <qpixmap.h>
#include <qtooltip.h>

#include <kiconloader.h>
#include <kapp.h>


extern KApplication *mykapp;



MyPushButton::MyPushButton( QWidget *parent )
						: QPushButton( parent )
{
	setMouseTracking( true );
   setFocusPolicy( NoFocus );

   draw_down = false;
   buttonpressed = false;
}


MyPushButton::~MyPushButton()
{
}


void MyPushButton::enterEvent( QEvent * )
{
	if (draw_down) return;
	draw_down = true;
   repaint();
}


void MyPushButton::leaveEvent( QEvent * )
{
	if (!draw_down) return;
   draw_down = false;
   repaint();
}


void MyPushButton::paint( QPainter *painter )
{
	bool draw_pressed = (isDown() || isOn());
	drawButtonLabel( painter );

   if (draw_pressed)
   {
   	if (style() == WindowsStyle)
      	qDrawWinButton( painter, 0, 0, width(), height(), colorGroup(), true );
		else
      	qDrawShadePanel( painter, 0, 0, width(), height(), colorGroup(), true, 2, 0L );
   }
   else
	   if (draw_down || config->buttonbar & BARFLG_PERSIST)
	   {
	   	if (style() == WindowsStyle)
	         qDrawWinButton( painter, 0, 0, width(), height(), colorGroup(), false );
	      else
	         qDrawShadePanel( painter, 0, 0, width(), height(), colorGroup(), false, 2, 0L );
	   }
}


void MyPushButton::drawButtonLabel( QPainter *painter )
{
	if (pixmap())
	{
		int dx = (width() - pixmap()->width()) / 2;
		int dy = (height() - pixmap()->height()) / 2;
		if (draw_down && style() == WindowsStyle)
		{
//			dx++;
//			dy++;
		}
		painter->drawPixmap( dx, dy, *pixmap() );
	}
}


void MyPushButton::mousePressEvent( QMouseEvent *e )
{
//   QPushButton::mousePressEvent( e );
	if (isDown()) return;

   bool hit = hitButton( e->pos() );
   if (hit)
   {
      buttonpressed = true;
   	setDown( true );
      repaint( false );
      emit pressed();
   }
}


void MyPushButton::mouseReleaseEvent( QMouseEvent *e )
{
   if (!isDown())
   {
   	releaseMouse();
      buttonpressed = false;
      return;
   }

   bool hit = hitButton( e->pos() );
   setDown( false );
   draw_down = false;
   if (hit)
   {
      if (isToggleButton())
      	setOn( !isOn() );
		repaint( false );
      if (isToggleButton())
      	emit toggled( isOn() );
      emit released();
      emit clicked();
   }
   else
   {
      repaint();
      emit released();
   }

   buttonpressed = false;
   releaseMouse();
}


void MyPushButton::mouseMoveEvent( QMouseEvent *e )
{
//   QPushButton::mouseMoveEvent( e );
	if (!buttonpressed) return;

   if (!(e->state() & LeftButton) &&
   	 !(e->state() & MidButton) &&
       !(e->state() & RightButton))
		return;

   bool hit = hitButton( e->pos() );
   if (hit)
   {
   	if (!isDown())
      {
      	setDown( true );
         repaint( false );
         emit pressed();
		}
   }
   else
   {
      if (isDown())
      {
      	setDown( false );
         repaint();
         emit released();
		}
	}
}


//---------------------------------------------------------------------------
//---------------------------------------------------------------------------


ButtonBar::ButtonBar( QWidget *parent, Direction d ) : QWidget( parent )
{
	QPixmap pm;
   KIconLoader *loader = mykapp->getIconLoader();


	btnConn = new MyPushButton( this );
   btnConn->setPixmap( loader->loadIcon( "connect.xpm" ) );
   connect( btnConn, SIGNAL(clicked()), this, SLOT(btnConnClicked()));
   QToolTip::add( btnConn, klocale->translate("Make connection") );

	btnDisc = new MyPushButton( this );
   btnDisc->setPixmap( loader->loadIcon( "disconnect.xpm" ) );
	connect( btnDisc, SIGNAL(clicked()), this, SLOT(btnDiscClicked()));
   QToolTip::add( btnDisc, klocale->translate("Disconnect this connection") );

	btnConfig = new MyPushButton( this );
   btnConfig->setPixmap( loader->loadIcon( "config.xpm" ) );
	connect( btnConfig, SIGNAL(clicked()), this, SLOT(btnConfigClicked()));
   QToolTip::add( btnConfig, klocale->translate("Channel settings") );

	btnFileSend = new MyPushButton( this );
   btnFileSend->setPixmap( loader->loadIcon( "transmit.xpm" ) );
	connect( btnFileSend, SIGNAL(clicked()), this, SLOT(btnFileSendClicked()));
   QToolTip::add( btnFileSend, klocale->translate("Send file") );

	btnFileRec = new MyPushButton( this );
   btnFileRec->setPixmap( loader->loadIcon( "receive.xpm" ) );
	connect( btnFileRec, SIGNAL(clicked()), this, SLOT(btnFileRecClicked()));
   QToolTip::add( btnFileRec, klocale->translate("Receive file") );

   direct = d;
   show();
}


ButtonBar::~ButtonBar()
{
}


void ButtonBar::setDirection( Direction d )
{
	direct = d;
}


void ButtonBar::resizeEvent( QResizeEvent *event )
{
	int a=0;
   int b;


   if (config->buttonbar & BARFLG_RIGHT)
   	b = BBARBTNSPACE-BBARBTNSIZE;
	else
   	b = 0;


	switch (direct)
   {
   	case Vertical:
			btnConn->setGeometry( b, a, BBARBTNSIZE, BBARBTNSIZE );
         a += BBARBTNSIZE;
			btnDisc->setGeometry( b, a, BBARBTNSIZE, BBARBTNSIZE );
         a += BBARBTNSIZE+5;
			btnConfig->setGeometry( b, a, BBARBTNSIZE, BBARBTNSIZE );
         a += BBARBTNSIZE+5;
			btnFileSend->setGeometry( b, a, BBARBTNSIZE, BBARBTNSIZE );
         a += BBARBTNSIZE;
			btnFileRec->setGeometry( b, a, BBARBTNSIZE, BBARBTNSIZE );
			break;
		case Horizontal:
			btnConn->setGeometry( 0, b, BBARBTNSIZE, BBARBTNSIZE );
         a += BBARBTNSIZE;
			btnDisc->setGeometry( a, b, BBARBTNSIZE, BBARBTNSIZE );
         a += BBARBTNSIZE+5;
			btnConfig->setGeometry( a, b, BBARBTNSIZE, BBARBTNSIZE );
         a += BBARBTNSIZE+5;
			btnFileSend->setGeometry( a, b, BBARBTNSIZE, BBARBTNSIZE );
         a += BBARBTNSIZE;
			btnFileRec->setGeometry( a, b, BBARBTNSIZE, BBARBTNSIZE );
      	break;
	}
}


void ButtonBar::btnConnClicked()
{
	emit connClicked();
}


void ButtonBar::btnDiscClicked()
{
	emit discClicked();
}


void ButtonBar::btnConfigClicked()
{
	emit configClicked();
}


void ButtonBar::btnFileSendClicked()
{
	emit fileSendClicked();
}


void ButtonBar::btnFileRecClicked()
{
	emit fileRecClicked();
}



