/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <keditcl.h>

#include "boxcheck.h"
#include "toolbox.h"
#include "channel.h"
#include "main.h"

#include <stdio.h>
#include <stdlib.h>

#include <kmsgbox.h>
#include <kwmmapp.h>

#include <qcolor.h>
#include <qkeycode.h>



#define BTNLENGTH 80
#define BTNHEIGHT 25

#define CMBWIDTH 150
#define CMBHEIGHT 20

#define TOOLWIDTH 25
#define TOOLHEIGHT 25


extern TopLevel *toplevel;

int sortField;


//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////


DlgTransfer::DlgTransfer( const char *board, int nr )
                   : QDialog( 0, "", true )
{
   char tmp[100];

   setCaption(klocale->translate("LinKT: transfer mail"));


   resize( 235, 120 );
   setFixedSize(size());

   sprintf(tmp, "Transfer: %s %i", board, nr);
   lTInfo = new QLabel( this );
   lTInfo->setGeometry( 10, 10, 250, 20 );
   lTInfo->setText( tmp );

   le_board = new QLineEdit( this );
   le_board->setGeometry( 10, 40, 60, 20 );
   le_board->setText("");
   le_board->setMaxLength( 8 );

   lAt = new QLabel( this );
   lAt->setGeometry( 82, 40, 15, 20);
   lAt->setText( "@" );

   le_mbx = new QLineEdit( this );
   le_mbx->setGeometry( 105, 40, 60, 20 );
   le_mbx->setText("");
   le_mbx->setMaxLength( 8 );

   lLt = new QLabel( this );
   lLt->setGeometry( 175, 40, 15, 20 );
   lLt->setText( "#" );

   eLt = new KIntLineEdit( this );
   eLt->setGeometry( 190, 40, 35, 20 );
	eLt->setMaxLength( 3 );



   int abstand = (width()-(2*BTNLENGTH))/3;
   btnSend = new QPushButton( this );
   btnSend->setGeometry(abstand, height()-BTNHEIGHT-5, BTNLENGTH, BTNHEIGHT);
   btnSend->setText( klocale->translate("&Send") );
   connect(btnSend, SIGNAL(clicked()), this, SLOT(accept()));
   btnSend->setDefault( true );

   btnAbort = new QPushButton( this );
   btnAbort->setGeometry(abstand*2+BTNLENGTH, height()-BTNHEIGHT-5, BTNLENGTH, BTNHEIGHT);
   btnAbort->setText( klocale->translate("&Abort") );
   connect(btnAbort, SIGNAL(clicked()), this, SLOT(reject()));

   le_board->setFocus();
}


DlgTransfer::~DlgTransfer()
{
	delete le_board;
	delete le_mbx;
	delete eLt;

	delete lAt;
	delete lTInfo;
	delete lLt;

	delete btnAbort;
	delete btnSend;
}


void DlgTransfer::getInfo( char *board, char *mbx, int & lt )
{
	char tmp[100];


   strcpy(board, le_board->text());
   strcpy(mbx, le_mbx->text());
   strcpy(tmp, eLt->text());
   if (tmp[0] == '\0')
   	lt = -1;
	else
   	lt = atoi(tmp);
}


//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////


DlgSetLT::DlgSetLT( const char *board, int nr )
                   : QDialog( 0, "", true )
{
   char tmp[100];

   setCaption(klocale->translate("LinKT: set new lifetime"));


   resize( 230, 120 );
   setFixedSize(size());

   sprintf(tmp, "Set lifetime for %s %i", board, nr);
   lLtInfo = new QLabel( this, tmp );
   lLtInfo->setGeometry( 10, 10, 250, 20 );

   eNewLt = new KIntLineEdit( this );
   eNewLt->setGeometry( 100, 40, 50, 20 );
   eNewLt->setText("");
   eNewLt->setMaxLength( 3 );

   lNewLt = new QLabel( this, "new lifetime:" );
   lNewLt->setGeometry( 10, 40, 80, 20);



   int abstand = (width()-(2*BTNLENGTH))/3;
   btnSend = new QPushButton( this );
   btnSend->setGeometry(abstand, height()-BTNHEIGHT-5, BTNLENGTH, BTNHEIGHT);
   btnSend->setText( klocale->translate("&Send") );
   connect(btnSend, SIGNAL(clicked()), this, SLOT(slotReturn()));
   btnSend->setDefault( true );

   btnAbort = new QPushButton( this );
   btnAbort->setGeometry(abstand*2+BTNLENGTH, height()-BTNHEIGHT-5, BTNLENGTH, BTNHEIGHT);
   btnAbort->setText( klocale->translate("&Abort") );
   connect(btnAbort, SIGNAL(clicked()), this, SLOT(reject()));

   eNewLt->setFocus();
}


DlgSetLT::~DlgSetLT()
{
   delete eNewLt;
   delete lNewLt;
   delete lLtInfo;

   delete btnAbort;
   delete btnSend;
}


int DlgSetLT::getLT()
{
   return newlt;
}


void DlgSetLT::slotReturn()
{
   newlt = atoi(eNewLt->text());

   if (newlt > 999 || newlt < 1)
   {
      KMsgBox::message(0, klocale->translate("Set Lifetime"), klocale->translate("The lifetime must be between 1 and 999."));
      return;
   }

   accept();
}


/////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////



BoxCheck::BoxCheck( QWidget *widget )
{
   parent = widget;
   status = 0;
   win = NULL;
   wronglines = 0;
}


BoxCheck::~BoxCheck()
{
   if (win != NULL)
   {
      delete win;
      win = NULL;
   }
}


void BoxCheck::readData( const char *desc )
{
	s_boxcheck *tmp;


	if (win != NULL)
	{
		delete win;
		win = NULL;
	}

	for (tmp=boxcheckroot; tmp; tmp=tmp->next)
		if (!strcmp(tmp->desc, desc) && tmp->enabled)
		{
			data = tmp;
			return;
		}

	data = NULL;
}


void BoxCheck::proceed( char *rxdata, int len )
{
	char *rxstr;
   int i, tmplen;
   char tmp[500], board[500]="", sender[500]="";
   int number=-1, lifetime=-1, size=-1;


   // Wenn keine BoxCheck-Konfiguration vorhanden ist, haben wir hier
   // nichts zu suchen.
   if (data == NULL) return;

   rxstr = (char *) malloc(len+1);
   memcpy(rxstr, rxdata, len);
   rxstr[len] = '\0';

   if ((i = POS('\r', rxstr)) > -1) rxstr[i] = '\0';
   if ((i = POS('\n', rxstr)) > -1) rxstr[i] = '\0';

   // Kommt eine neue Titelzeile an?
   if (!strcmp(rxstr, data->title))
   {
   	// Ja, neuer Titel. Fenster wenn noch nicht vorhanden erstellen, sonst
      // leeren.
      wronglines = 0;
      if (win == NULL)
      {
         win = new BoxCheckWin( this, data->type, data->title );
		}
      else
			win->clear();
      ((Channel *)parent)->enableBoxcheckMenu();
		win->setFields( data->fields );
      free(rxstr);
      return;
   }

   if (wronglines >= 5)
   {
   	free(rxstr);
      return;
   }

   // Keine Titelzeile. Wenn das Fenster nicht vorhanden ist, abbrechen.
   if (win == NULL)
   {
   	free(rxstr);
   	return;
	}

	// Wenn die Zeile zu kurz ist, wird auch nicht weitergemacht.
   if (strlen(rxstr) < data->minlen)
   {
      wronglines++;
   	return;
   }

   // Sooo... Anhand der festen Zeichen wird ueberprueft, ob dieser Eintrag
   // korrekt ist. Nach mehr als 5 falschen Zeilen wird die Ueberpruefung
   // abgebrochen.
   for (i=0; i<data->mustcount; i++)
   {
      if (rxstr[data->must[i].pos] != data->must[i].zeichen)
      {
         wronglines++;
			free(rxstr);
         return;
      }
	}

	// Korrekter Eintrag
	wronglines = 0;


   if (data->board != NULL)
   {
   	strncpy(board, rxstr+data->board->pos, data->board->len);
      i = strlen(board)-1;
      while (board[i] == '.' && i >= 0)
      {
      	board[i] = '\0';
         i--;
		}
	}

	if (data->number != NULL)
   {
   	strncpy(tmp, rxstr+data->number->pos, data->number->len);
      tmplen = strlen(tmp);
      while (tmp[0] == '.')
      {
      	tmplen--;
         memmove(tmp, tmp+1, tmplen);
      }
      tmp[tmplen] = '\0';
      number = atoi(tmp);
   }

   // Absender
   if (data->sender != NULL)
   {
   	strncpy(sender, rxstr+data->sender->pos, data->sender->len);
      KillSpacesRight(sender);
   }

   if (data->lifetime != NULL)
   {
   	strncpy(tmp, rxstr+data->lifetime->pos, data->lifetime->len);
		KillSpacesRight(tmp);
		KillSpacesLeft(tmp);
      lifetime = atoi(tmp);
      if (lifetime == 0) lifetime = -1;
   }

   if (data->size != NULL)
   {
   	strncpy(tmp, rxstr+data->size->pos, data->size->len);
		KillSpacesRight(tmp);
		KillSpacesLeft(tmp);
      size = atoi(tmp);
      if (size == 0) size = -1;
   }

   win->addEntry( rxstr, sender, board, number, NULL, NULL, size, lifetime );

   free(rxstr);
}


void BoxCheck::showWindow()
{
   if (win == NULL)
   {
      KMsgBox::message(0, klocale->translate("BoxCheck"), klocale->translate("You didn't receive a checklist until now."));
      return;
   }

   KWM::activate(win->winId());
   win->show();
   win->setFocus();
}


void BoxCheck::sendString( char *str )
{
   ((Channel *)parent)->sendString(str);
}


void BoxCheck::setNewFont()
{
   if (win == NULL) return;

   win->setNewFont();
}



//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////


BoxCheckEntry::BoxCheckEntry( QListView *parent, char *line, char *sender, char *rubrik, int nr, char *datum, char *mbx, int bytes, int lt)
						: QListViewItem( parent, line )
{
	if (rubrik[0] == '\0')
		this->board = NULL;
	else
		this->board = (char *) strdup(rubrik);
	this->nr = nr;
   this->lt = lt;
   this->size = bytes;
	if (sender[0] == '\0')
		this->sender = NULL;
	else
		this->sender = (char *) strdup(sender);
}


BoxCheckEntry::~BoxCheckEntry()
{
	if (this->board != NULL)
		free(this->board);
}


const char * BoxCheckEntry::getBoardName()
{
	return board;
}


int BoxCheckEntry::getMailNr()
{
	return nr;
}


int BoxCheckEntry::getLifetime()
{
	return lt;
}


//QString BoxCheckEntry::key( int col, bool absteigend )
const char * BoxCheckEntry::key( int col, bool absteigend ) const
{
	static char tmp[100];


   switch (sortField)
   {
   	case BCFIELD_NUMBER:
         if (board == NULL)
				sprintf(tmp, "%6i", nr);
			else
				sprintf(tmp, "%-8s%.6i", board, nr);
         return tmp;
		case BCFIELD_LIFETIME:
      	sprintf(tmp, "%.5i", lt);
         return tmp;
		case BCFIELD_SIZE:
      	sprintf(tmp, "%.10i", size);
         return tmp;
		case BCFIELD_SENDER:
      	sprintf(tmp, "%8s", sender);
         return tmp;
      default: return QListViewItem::key( col, absteigend );
   }
}



//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////


BoxCheckWin::BoxCheckWin( QObject *prnt, int type, char *title )
     : QDialog( 0, "", false )
{
   parent = prnt;
   this->type = type;


   resize(600, 350);

	liste = new QListView( this );
   liste->setGeometry( 0, BTNHEIGHT+15, width(), height()-2*(BTNHEIGHT+15));
   liste->setFont( QFont(config->bcfontstr, config->bcfontsize) );
   liste->setMultiSelection( true );
   liste->setFocus();

	liste->addColumn(title);
	liste->addColumn("", 0);	// TODO: Zeile ab Qt2 loeschen

	liste->setSorting( 0, true );
	sortcol = 0;


	connect( liste, SIGNAL(doubleClicked(QListViewItem *)), this, SLOT(slotReadCmd(QListViewItem *)));
	connect( this, SIGNAL(sendString(char *)), parent, SLOT(sendString(char *)) );

	// Liste der Sortiermoeglichkeiten
	lSort = new QLabel( this );
	lSort->setText(klocale->translate("Sort by"));
	lSort->resize(lSort->sizeHint());
	lSort->setGeometry( width()-25-CMBWIDTH-lSort->width(), 10, lSort->width(), 20 );

   cmbSort = new QComboBox( this );
   cmbSort->setGeometry( width()-15-CMBWIDTH, 10, CMBWIDTH, CMBHEIGHT );
   connect( cmbSort, SIGNAL(activated(const char *)), this, SLOT(slotChangeSorting(const char *)));

	// Buttons fuer die anderen Funktionen
   btnTrans = new QPushButton( this );
   btnTrans->setGeometry( 15+0*(TOOLWIDTH+10), 10, TOOLWIDTH, TOOLHEIGHT);
   btnTrans->setText( "TR");
   connect( btnTrans, SIGNAL(clicked()), this, SLOT(slotTransClicked()));
   aTr = new QAccel( this );
   aTr->connectItem( aTr->insertItem( Key_T+CTRL ), this, SLOT(slotTransClicked()) );


   btnSetLT = new QPushButton( this );
   btnSetLT->setGeometry( 15+1*(TOOLWIDTH+10), 10, TOOLWIDTH, TOOLHEIGHT);
   btnSetLT->setText( "LT" );
   connect( btnSetLT, SIGNAL(clicked()), this, SLOT(slotSetLTClicked()));

   aLt = new QAccel( this );
   aLt->connectItem( aLt->insertItem( Key_L+CTRL ), this, SLOT(slotSetLTClicked()) );


   btnRead = new QPushButton( this );
   btnRead->setGeometry( 15+2*(TOOLWIDTH+10), 10, TOOLWIDTH, TOOLHEIGHT);
   btnRead->setText( "R" );
   connect( btnRead, SIGNAL(clicked()), this, SLOT(slotReadClicked()));

   aR = new QAccel( this );
   aR->connectItem( aR->insertItem( Key_R+CTRL ), this, SLOT(slotReadClicked()) );


   btnErase = new QPushButton( this );
   btnErase->setGeometry( 15+3*(TOOLWIDTH+10), 10, TOOLWIDTH, TOOLHEIGHT);
   btnErase->setText( "E" );
   connect( btnErase, SIGNAL(clicked()), this, SLOT(slotEraseClicked()));

   aE = new QAccel( this );
   aE->connectItem( aE->insertItem( Key_E+CTRL ), this, SLOT(slotEraseClicked()) );


   int abstand = (width()-(2*BTNLENGTH))/3;
   send = new QPushButton( this );
   send->setGeometry(abstand, height()-BTNHEIGHT-5, BTNLENGTH, BTNHEIGHT);
   send->setText( klocale->translate("&Send") );
   connect(send, SIGNAL(clicked()), this, SLOT(slotSend()));

   abort = new QPushButton( this );
   abort->setGeometry(abstand*2+BTNLENGTH, height()-BTNHEIGHT-5, BTNLENGTH, BTNHEIGHT);
   abort->setText( klocale->translate("&Abort") );
   connect(abort, SIGNAL(clicked()), this, SLOT(reject()));
}


BoxCheckWin::~BoxCheckWin()
{
	delete liste;
   delete cmbSort;
   delete lSort;

   delete send;
   delete abort;

   delete aLt;
   delete aTr;
   delete aR;
   delete aE;
}


void BoxCheckWin::setFields( int fields )
{
	cmbSort->clear();

   if (fields & BCFIELD_BOARD && fields & BCFIELD_NUMBER)
   {
   	cmbSort->insertItem( klocale->translate("Board & Number") );
      if (cmbSort->count() == 1)
         sortField = BCFIELD_NUMBER;
	}

	if (fields & BCFIELD_LIFETIME)
	{
   	cmbSort->insertItem( klocale->translate("Lifetime") );
      if (cmbSort->count() == 1)
         sortField = BCFIELD_LIFETIME;
	}

	if (fields & BCFIELD_SIZE)
 	{
   	cmbSort->insertItem( klocale->translate("Size") );
      if (cmbSort->count() == 1)
         sortField = BCFIELD_SIZE;
	}

	if (fields & BCFIELD_SENDER)
	{
   	cmbSort->insertItem( klocale->translate("Sender") );
      if (cmbSort->count() == 1)
         sortField = BCFIELD_SENDER;
	}

	btnSetLT->setEnabled( fields & BCFIELD_LIFETIME );
}


void BoxCheckWin::addEntry( char *line, char *sender, char *rubrik, int nr, char *datum, char *mbx, int bytes, int lt)
{
	BoxCheckEntry *entry = new BoxCheckEntry( liste, line, sender, rubrik, nr, datum, mbx, bytes, lt );
//	BoxCheckEntry::BoxCheckEntry( liste, line, sender, rubrik, nr, datum, mbx, bytes, lt );
}


void BoxCheckWin::clear()
{
	liste->clear();
}


void BoxCheckWin::slotSend()
{
   BoxCheckEntry *entry;
   const char *board;
   char tmp[200]="", str[200]="", lastboard[500]="";
   int nr, startnr=-1, endnr=-1;


   if ((entry = (BoxCheckEntry *)liste->firstChild()) == NULL) return;

   do
   {
      if (entry->isSelected())
      {
         nr = entry->getMailNr();
         board = entry->getBoardName();
			if (nr > 0)
			{
				if (!strcmp(lastboard, board))
				{
					// Das selbe Board.
					if (nr == endnr+1)
					{
						// Die folgende Mail im selben Board.
						endnr++;
					}
					else
					{
						// Eine neue Mail der gleichen Rubrik.
						if (startnr != endnr)
							sprintf(tmp, "R %s %i-%i", board, startnr, endnr);
						else
							sprintf(tmp, "R %s %i", board, startnr);
						startnr = nr;
						endnr = nr;
						if (str[0] == '\0')
							strcpy(str, tmp);
						else
							sprintf(str+strlen(str), ";%s", tmp);
					}
				}
				else
				{
					// Ein anderes Board
					if (startnr != -1)
						if (startnr != endnr)
							sprintf(tmp, "R %s %i-%i", lastboard, startnr, endnr);
					else
						sprintf(tmp, "R %s %i", lastboard, startnr);
					startnr = nr;
					endnr = nr;
					strcpy(lastboard, board);
					if (str[0] == '\0')
						strcpy(str, tmp);
					else
						sprintf(str+strlen(str), ";%s", tmp);
			   }
         }
         entry->setSelected( false );
      }
   } while ((entry = (BoxCheckEntry *)entry->nextSibling()) != NULL);


   if (startnr != -1)
   {
		if (startnr != endnr)
			sprintf(tmp, "R %s %i-%i", lastboard, startnr, endnr);
		else
			sprintf(tmp, "R %s %i", lastboard, startnr);

		if (str[0] == '\0')
			strcpy(str, tmp);
		else
			sprintf(str+strlen(str), ";%s", tmp);
  }

   if (str[0] != '\0')
   {
   	strcat(str, "\r");
   	emit sendString( str );
	}
}


void BoxCheckWin::resizeEvent(QResizeEvent *event)
{
   QDialog::resizeEvent(event);

   liste->setGeometry( 0, BTNHEIGHT+15, width(), height()-2*(BTNHEIGHT+15));

   int abstand = (width()-(2*BTNLENGTH))/3;
   send->setGeometry(abstand, height()-BTNHEIGHT-5, BTNLENGTH, BTNHEIGHT);
   abort->setGeometry(abstand*2+BTNLENGTH, height()-BTNHEIGHT-5, BTNLENGTH, BTNHEIGHT);
}


void BoxCheckWin::slotReadCmd(QListViewItem *item)
{
	const char *board;
   int nr;
   char tmp[100];


   board = ((BoxCheckEntry *)item)->getBoardName();
   nr = ((BoxCheckEntry *)item)->getMailNr();

	if (board == NULL)
   	sprintf(tmp, "R %i\r", nr);
	else
		sprintf(tmp, "R %s %i\r", board, nr);

	emit sendString( tmp );
}


void BoxCheckWin::slotChangeSorting( const char *string )
{
	// TODO: liste->setSorting wird bei Qt2 durch sort() ersetzt.
	if (!strcmp(string, klocale->translate("Board & Number")))
	{
		sortField = BCFIELD_NUMBER;
      if (sortcol == 0)
      	sortcol = 1;
		else
      	sortcol = 0;
   	liste->setSorting( sortcol, true );
		return;
	}

	if (!strcmp(string, klocale->translate("Lifetime")))
	{
		sortField = BCFIELD_LIFETIME;
      if (sortcol == 0)
      	sortcol = 1;
		else
      	sortcol = 0;
   	liste->setSorting( sortcol, true );
      return;
	}

	if (!strcmp(string, klocale->translate("Size")))
	{
		sortField = BCFIELD_SIZE;
      if (sortcol == 0)
      	sortcol = 1;
		else
      	sortcol = 0;
   	liste->setSorting( sortcol, true );
      return;
	}

	if (!strcmp(string, klocale->translate("Sender")))
	{
		sortField = BCFIELD_SENDER;
      if (sortcol == 0)
      	sortcol = 1;
		else
      	sortcol = 0;
   	liste->setSorting( sortcol, true );
      return;
	}
}


void BoxCheckWin::slotTransClicked()
{
   BoxCheckEntry *entry;
   char newboard[100], newmbx[100], tmp[500];
   const char *board;
   int nr, newlt;


   if ((entry = (BoxCheckEntry *)liste->currentItem()) == NULL) return;
   board = entry->getBoardName();
   nr = entry->getMailNr();

   DlgTransfer *dlg = new DlgTransfer(board, nr);

   dlg->setGeometry((this->width()-dlg->width())/2,
     		           (this->height()-dlg->height())/2,
  		              dlg->width(),dlg->height());

   if (dlg->exec() == 1)
   {
      dlg->getInfo( newboard, newmbx, newlt );

      if (newboard[0] == '\0') return;
      if (type == BCTYPE_BAYBOX)
      {
			sprintf(tmp,"TR %s %i %s", board, nr, newboard);
			if (newmbx[0] != '\0')
				sprintf(tmp+strlen(tmp), " @ %s", newmbx);
   		if (newlt != -1)
         	sprintf(tmp+strlen(tmp), " #%i\n", newlt);
			else
				strcat(tmp, "\r");
      }
/*			sprintf(tmp,"sc %i %s", nr, newboard);
			if (newmbx[0] != '\0')
				sprintf(tmp+strlen(tmp), "@%s\r/ex\r", newmbx);
			else
				strcat(tmp, "\r/ex\r");
		}*/
      emit sendString( tmp );
   }

   delete dlg;
}


void BoxCheckWin::slotSetLTClicked()
{
   BoxCheckEntry *entry;
   char tmp[500];
   int nr, newlt;
   const char *board;

   
   if ((entry = (BoxCheckEntry *)liste->currentItem()) == NULL) return;
   board = entry->getBoardName();
   nr = entry->getMailNr();

   DlgSetLT *dlg = new DlgSetLT(board, nr);

   dlg->setGeometry((this->width()-dlg->width())/2,
     		           (this->height()-dlg->height())/2,
  		              dlg->width(),dlg->height());

   if (dlg->exec() == 1)
   {
      newlt = dlg->getLT();

      sprintf(tmp,"SETL %s %i %i\r", board, nr, newlt);
      emit sendString( tmp );
   }

   delete dlg;
}


void BoxCheckWin::slotReadClicked()
{
   BoxCheckEntry *entry;
   char tmp[500];
   int nr;
   const char *board;


   if ((entry = (BoxCheckEntry *)liste->currentItem()) == NULL) return;
   board = entry->getBoardName();
   nr = entry->getMailNr();

   sprintf(tmp, "R %s %i\r", board, nr);
   emit sendString( tmp );
}


void BoxCheckWin::slotEraseClicked()
{
   char tmp[500];
   const char *board;
   int nr;
   BoxCheckEntry *entry;


   if ((entry = (BoxCheckEntry *)liste->currentItem()) == NULL) return;
   board = entry->getBoardName();
   nr = entry->getMailNr();

   sprintf(tmp, klocale->translate("Do you really want to delete the mail %s %i?"),
                board, nr);

   if (KMsgBox::yesNo(NULL,
                      klocale->translate("Delete Mail?"),
                      tmp,
                      0,
                      klocale->translate("&Yes"),
                      klocale->translate("&No")) != 1)
      return;
   if (type == BCTYPE_BAYBOX)
     sprintf( tmp,"E %s %i\r", board, nr );
/*   if (type==BOXC_TYPE_RLI)
     sprintf(tmp, "k %i\r",nr);*/
   emit sendString( tmp );
}


void BoxCheckWin::setNewFont()
{
   liste->setFont( QFont(config->bcfontstr, config->bcfontsize) );
   liste->triggerUpdate();
}



#include "boxcheck.moc"

