.\"
.\" Copyright (c) 1999 by The XFree86 Project, Inc.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"  
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE XFREE86 PROJECT BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
.\" WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
.\" OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
.\" SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the XFree86 Project shall
.\" not be used in advertising or otherwise to promote the sale, use or other
.\" dealings in this Software without prior written authorization from the
.\" XFree86 Project.
.\"
.\" Author: Paulo Csar Pereira de Andrade
.\"
.\" $XFree86: xc/lib/Xaw/Xaw.man,v 1.4 1999/06/27 14:07:35 dawes Exp $
.\"
.de TQ
.br
.ns
.TP \\$1
..
.TH XAW 3 "Version 3.9" "XFree86"

.SH NAME
 XAW \- X Athena Widgets

.SH DESCRIPTION
.B Xaw
is a Widget set based on the Xt Intrinsics.  This manual page describes the
XFree86 additions and modifications to the Xaw library,  as well as some of
the common interfaces.

.SH ACTIONS
All the \fIXaw\fR widgets now have the additional translations
.B call-proc, declare, get-values
and  \fBset-values\fP. The syntax for these actions is:
.br
.I action-name(boolean-expression, arguments)
.br
\fBAction-name\fP is one of \fIcall-proc\fP, \fIdeclare\fP,
\fIget-values\fP or \fIset-values\fP.
.br
\fBBoolean-expression\fP is composed with the operators \fI|\fR (or), \fI&\fR
(and), \fI^\fR (xor), and \fI~\fR (not). The operands can be a variable name,
that starts with a \fI$\fR; a resource name without the bindings \fI.\fP
and \fI*\fP; or a constant name, including \fImine\fP (event->xany.window
== XtWindow(widget)), \fIfaked\fP (event->xany.send_event != 0), \fItrue\fP (1)
and \fIfalse\fP (0).
.br
\fBArguments\fP are self explanatory, when starting with a \fI$\fP they name
a variable, else, a resource name.
.TP 8
.B call-proc
This action allows the evaluation of a boolean expression, in the first
parameter, before calling a action procedure. Only if the expression resolves
to true the procedure is called. Example:
.br
.I call-proc("$inside & $pressed", notify)
.TP 8
.B declare
This action, like \fIget-values\fP is used to create new variables, or
change their value. Example:
.br
.I declare(1, $pressed, 1)
.TP 8
.B get-values
This actions allows reading a resource value into a variable.
Example:
.br
.I get-values(1, $fg, foreground, $bg, background)
.TP 8
.B set-values
This action allow setting a resource in the widget. Example:
.br
.I set-values(1, foreground, $bg, background, $fg)

.PP
Sample translation to make a label widget behave like a button:
.nf
<Map>:      get-values(1, $fg, foreground, $bg, background)\\n\\
<Btn1Down>: set-values(1, foreground, yellow, background, gray30)\\n\\
<Btn1Up>:   set-values(1, foreground, $fg, background, $bg)
.fi

.SH DISPLAY LISTS
All the \fBXaw\fP widgets have now the additional resource \fIdisplayList\fP.
This resource allows drawing the widget decorations with commands embedded
in the resource string.
The displayList resource has the syntax:
.br
\fI[class-name:]function-name arguments[[{;\\n}]...]\fP
.br
\fBClass-name\fP is any registered set of functions to draw in the widget.
Currently the only existing class is \fIxlib\fP.
.br
\fBFunction-name\fP is the drawing or configuration function to be called,
described bellow.
.br
\fBArguments\fP may be anything suitable to the displayList function being
called. When the function requires a coordinate, the syntax is
\fI{+-}<integer>\fP or \fI<integer>/<integer>\fP. Examples:
.nf
	+0,+0      top, left
	-0,-0      bottom, right
	-+10,-+10  bottom+10, right+10
	+0,1/2     left, vertical-center
.fi

.TP 8
.B arc-mode \fPmode
Sets the arc mode. Accepted parameters are "pieslice" and "chord", that sets
the arc to ArcPieSlice or ArcChord, respectively. Example:
.br
.I arc-mode chord
.TP 8
.B bg \fPcolor-spec
.TQ
.B background \fPcolor-spec
Sets the  background  color. Argument  must  as  valid color  specification.
Example:
.br
.I background red
.TP 8
.B cap-style \fPstyle
Sets the cap style. Accepted parameters are  "notlast", "butt", "round", and
"projecting", that sets  the cap  style to  CapNotLast, CapBut,  CapRound or
CapProjecting, respectively. Example:
.br
.I cap-style round
.TP 8
.B clip-mask \fPpixmap-spec
Sets the pixmap for the clip mask. Requires a pixmap parameter, as described
in the \fBPIXMAPS\fP section of this man page. Example:
.br
.I clip-mask xlogo11
.TP 8
.B clip-origin \fPx,y
Sets the clip x and y origin. Requires two arguments,  a x and y coordinate.
Example:
.br
.I clip-origin 10,10
.TP 8
.B clip-rects \fPx1,y1,x2,y2 [...,xn,yn]
.TQ
.B clip-rectangles \fPx1,y1,x2,y2 [...,xn,yn]
Sets a list of rectangles to the clip mask. The  number of arguments must be
a multiple of four. The arguments are coordinates. The parser calculates the
width and height of the rectangles. Example:
.br
.I clip-rects 0,0,10,20, 20,10,30,30
.TP 8
.B coord-mode \fPmode
Changes  the  coord  mode  for   \fIfill-polygon\fP,  \fIdraw-lines\fP,  and
\fIdraw-points\fP. Accepted parameters are "modeorigin" and "previous", that
sets the coord mode  to CoordModeOrigin or  CoordModePrevious, respectively.
Example:
.br
.I coord-mode previous
.TP 8
.B copy-area \fP{pixmap-spec|.},dstx,dsty[,x2,y2,srcx,srcy]
Calls XCopyArea.  The  character \fI.\fP  means  copy  the window  contents,
pixmap-spec is as defined in  the \fIPIXMAPS\fP sction of  this manual page.
\fIX2\fP, and \fIy2\fP are  coordinates of the  end copy, not the  width and
height;  if  not  defined,   the  parser  calculates  it.   \fISrc_x\fP  and
\fIsrc_y\fP defaults to zero. Example:
.br
.I copy-area Term,10,10
.TP 8
.B copy-plane \fP{pixmap-spec|.},dstx,dsty[,x2,y2,srcx,srcy,plane]
Calls XCopyPlane.  The character  \fI.\fP  means copy  the window  contents,
pixmap-spec is as defined in  the \fIPIXMAPS\fP sction of  this manual page.
\fIX2\fP, and \fIy2\fP are  coordinates of the  end copy, not the  width and
height;  if  not  defined,   the  parser  calculates  it.   \fISrc_x\fP  and
\fIsrc_y\fP defaults to zero. \fIPlane\fP defaults to one. Example:
.br
.I copy-plane star,10,10
.TP 8
.B dashes \fPi1[...,in]
Sets the dashes for line drawing. Accepts up to 127 arguments. Example:
.br
.I dashes 3,7 9,10
.TP 8
.B draw-arc \fPx1,y1,x2,y2[,start-angle,end-angle]
Draws an arc. The four first arguments are  the rectangle enclosing the arc.
The two  remaining  arguments, if  any,  are the  start  and  end angle,  in
degrees. Example:
.br
.I draw-arc +0,+0,-1,-1,0,90
.TP 8
.B draw-rect \fPx1,y1,x2,y2
.TQ
.B draw-rectangle \fPx1,y1,x2,y2
Draws a  rectangle. Requires  four arguments,  that  are the  start and  end
coordinates. Example:
.br
.I draw-rect +1,+1,-5,-5
.TP 8
.B draw-string \fPx,y,"string"
Draws a  text  string.  Requires  three  arguments,  a  x  coordinate,  a  y
coordinate and a string. Strings  that have white spaces can  be quoted with
the \fI"\fP character,  the character  \fI\\\fP can also  be used,  but, you
need to escape this character twice. Example:
.br
\fI draw-string 10,10, "Hello world!"\fP
.TP 8
.B exposures \fPboolean
Sets the graphics exposures in  the GC. Allowed parameters are  a integer or
the strings "true", "false", "on" and "off". Example:
.br
.I exposures true
.TP 8
.B fill-arc \fPx1,y1,x2,y2[,start-angle,end-angle]
Like \fIdraw-arc\fP, but fills  the contents of  the arc with  the currently
selected foreground. Example:
.br
.I fill-arc +0,+0,-1,-1,0,180
.TP 8
.B fill-poly \fPx1,y1 [...,xn,yn]
.TQ
.B fill-polygon \fPx1,y1 [...,xn,yn]
Like \fIdraw-lines\fP, but  fills the enclosed  polygon and joins  the first
and last point, if they are not at the same position. Example:
.br
.I fill-poly +0,+10, +10,+20, +30,+0
.TP
.B fill-rect \fPx1,y1,x2,y2
.TQ
.B fill-rectangle \fPx1,y1,x2,y2
Like \fIdraw-rect\fP,  but fills  the  contents of  the  rectangle with  the
selected foreground color. Example:
.br
.I fill-rect +10,+10,-20,-20
.TP 8
.B fill-rule \fPrule
Sets the fill  rule. Accepted parameters  are "evenodd" and  "winding", that
sets the fill rule to EvenOddRule or WindingRule, respectively. Example:
.br
.I
fill-rule winding
.TP 8
.B fill-style \fPstyle
Sets the fill style. Allowed parameters are "solid", "tiled", "stippled" and
"opaquestippled",  that  sets  the  fill  style   to  FillSolid,  FillTiled,
FillStippled or FillOpaqueStippled, respectively. Example:
.br
.I fill-style tiled
.TP 8
.B font \fPfont-spec
Sets the font for text functions. Example:
.br
.I font -*-*-*-R-*-*-*-120-*-*-*-*-ISO8859-1
.TP 8
.B fg \fPcolor-spec
.TQ
.B foreground \fPcolor-spec
Like \fIbackground\fP, but sets the current foreground color. Example:
.br
.I foreground blue
.TP 8
.B mask
This command is useful when you want to draw only  in the region that really
needs to be repainted. Requires no arguments.
.TP 8
.B function \fPfunction-spec
Sets the specific GC function. Allowed parameters are "set", "clear", "and",
"andreverse", "copy",  "andinverted", "noop",  "xor", "or",  "nor", "equiv",
"invert", "orreverse", "copyinverted" and  "nand", that set the  function to
GXset, GXclear, GXand,  GXandReverse, GXcopy, GXandInverted,  GXnoop, GXxor,
GXor, GXnor,  GXequiv,  GXinvert,  GXorReverse,  GXcopyInverted  or  GXnand,
respectively. Example:
.br
.I function xor
.TP 8
.B join-style \fPstyle
Sets the join  style. Allowed parameters  are "miter", "round"  and "bevel",
that  sets   the  join   style  to   JoinMiter,  JoinRound   and  JoinBevel,
respectively. Example:
.br
.I join-style round
.TP 8
.B image \fP{pixmap-spec},xs,ys,[xe,ye]
This function is implemented as a way to quickly compose complex decorations in
widgets. \fIPixmap-spec\fP is as defined in the \fIPIXMAPS\fP section of this
manual page, \fIxs\fP and \fIys\fP are the coodinates from where start copying
the pixmap, \fIxe\fP and \fIye\fP are optional (defaults to xs + pixmap.width
and ys + pixmap.height respectively). If the pixmap has a mask, the copy is
masked accordingly. Example:
.br
.I image pixmap.xpm,0,0,20,20
.TP 8
.B line \fPx1,y1,x2,y2
.TQ
.B draw-line \fPx1,y1,x2,y2
Draws a  line with  the current  foreground color.  Require four  arguments.
Example:
.br
.I line +0,+0, -1,-1
.TP 8
.B line-width \fPinteger
Allow selecting a different line width for the drawing. Example:
.br
.I line-width 2
.TP 8
.B line-style \fPstyle
Sets the  line  style.  Accepted  parameters  are "solid",  "onoffdash"  and
"doubledash", that  sets  the  line  style  to LineSolid,  LineOnOffDash  or
LineDoubleDash, respectively. Example:
.br
.I line-style onoffdash
.TP 8
.B lines \fPx1,y1,x2,y2 [...,xn,yn]
.TQ
.B draw-lines \fPx1,y1,x2,y2 [...,xn,yn]
Draws a list of lines. Any number of arguments may be supplied. Example:
.br
.I lines +0,-1, -1,-1, -1,+0
.TP 8
.B paint-string \fPx,y,"string"
Identical to draw-string, but also uses the background color. Example:
.br
\fI paint-string 10,20, "Sample text"\fP
.TP 8
.B point \fPx,y
.TQ
.B draw-point \fPx,y
Draws a point. Requires two arguments. Example:
.br
.I point +10,+10
.TP 8
.B plane-mask \fPinteger
Allows setting the plane mask. Requires a integer parameter. Example:
.br
.I plane-mask -1
.TP 8
.B points \fPx1,y1 [...,xn,yn]
.TQ
.B draw-points \fPx1,y1 [...,xn,yn]
Draws a list of points at the specified coordinates. Example:
.br
.I points +1,+2, +1,+4, +1,+6
.TP 8
.B segments \fPx1,y1,x2,y2 [...,xn,yn]
.TQ
.B draw-segments \fPx1,y1,x2,y2 [...,xn,yn]
Draws a list of segment lines.  Number of parameters must be  multiple of 4.
Example:
.br
.I segments +1,+2,+1,-3, +2,-2,-3,-2
.TP 8
.B shape-mode \fPmode
Allows  setting  the  shape   mode  used  in   \fIfill-polygon\fP.  Accepted
parameters are "complex", "convex" or "nonconvex", that  sets the shape mode
to Complex, Convex or Nonconvex, accordingly. Example:
.br
.I shape-mode convex
.TP 8
.B stipple \fPpixmap-spec
Sets the pixmap for the  stipple. Requires a pixmap  parameter, as described
in the \fBPIXMAPS\fP section of this man page. Example:
.br
.I stipple plaid
.TP 8
.B subwindow-mode \fPmode
Sets   the   subwindow   mode   in   the   GC.   Accepted   parameters   are
"includeinferiors" and  "clipbychildren", that  sets the  subwindow mode  to
IncludeInferiors or ClipByChildren, respectively. Example:
.br
.I subwindow-mode includeinferiors
.TP 8
.B tile \fPpixmap-spec
Sets the pixmap for the  tile. Requires a pixmap parameter,  as described in
the \fBPIXMAPS\fP section of this man page. Example:
.br
.I tile xlogo11?foreground=red&background=gray80
.TP 8
.B ts-origin \fPx,y
Sets the tile  stipple x and  y origin.  Requires two arguments,  a x  and y
coordinate. Example:
.br
.I ts-origin 10,10
.TP 8
.B umask
Disables the gc mask, when it was set  with the command \fImask\fP. Requires
no arguments.

.PP
Example for drawing a shadow effect in a widget:
.nf
foreground gray30;\\
draw-lines +1,-1,-1,-1,-1,+1;\\
foreground gray85;\\
draw-lines -1,+0,+0,+0,+0,-1
.fi

.SH PIXMAPS
A String to Pixmap converter was added to \fBXaw\fP. This converter is meant to
be extended, and has enough abstraction to allow loading several image formats.
It uses a format that resembles a \fIURL\fP, with the syntax:
.br
.I [type:]name[?arg=val[{&}...]]
.br
\fBType\fP actually can be one of \fIbitmap\fP, \fIgradient\fP or \fIxpm\fP.
.br
\fBName\fP may be a file name, or, in the case of type \fIgradient\fP, may be
either \fIvertical\fP or \fIhorizontal\fP.
.br
\fBArg=val\fP is a list of arguments to the converter. The most common arguments
are \fIforeground\fP and \fIbackground\fP. Gradients supports also the arguments
\fIstart\fP and \fIend\fP (colors to start and end the gradient); the
\fPsteps\fP argument, to allow using less colors; and the \fIsize\fP argument
to specify the size of the gradient. The \fIxpm\fP converter understands the
\fIcloseness\fP argument, that helps using less colors (useful if you have a
limited colormap).

.SH TEXT WIDGET
Most of the changes to this version of the Xaw library were done in the
TextWidget, TextSrcObject, TextSinkObject and related files. The text widget
is based in the emacs text editor. In this release, the emacs compatibility
was increased. New text actions include:
.TP 8
.B indent
This action allow indenting text blocks. It is not enabled by default. A
translation to call this action was added to the \fIxedit\fP editor, binded to
\fIControl<Key>X,<Key>Tab\fP.
.TP 8
.B keyboard-reset
Resets the keyboard state. Reverts the multiply to 1, and if undo is enabled,
toggle between undo and redo. Binded by default to \fIControl<Key>G\fP.
.TP 8
.B kill-ring-yank
In this version of Xaw, text killed in any text field is kept in memory,
allowing to cut and paste internally to the program between text fields.
The default key binding to this actions is \fIMeta<Key>Y\fP.
.TP 8
.B numeric
Listed here only for purposes of documentation. It is called by default when
one of the characters \fI1, 2, 3, 4, 5, 6, 7, 8, 9, 0,\fP or \fI-\fP is typed,
allowing composing the multiplication number of text actions.
.TP 8
.B set-keyboard-focus
This action is normally binded to the \fI<Btn1Down>\fP event. Will set the input
focus on the top level widget to the text field. Not enabled by default.
.TP 8
.B toggle-overwrite
This action toggles overwrite mode. In overwrite mode, any text inserted in
a text field will replace existing text. Normally binded to \fI<Key>Insert\fP.
.TP 8
.B undo
Binded by default to \fIControl<Key>_\fP, will call the undo function. Undo is
not enabled by default. It is enabled setting the \fIenableUndo\fP resource of
the textSrcObject.

.PP
The new text resources include:
.TP 8
.B justify (\fPClass\fB Justify)
Sets the text justification. Can be one of \fIleft, right, center\fP or
\fIfull\fP. Only enabled when the \fIautoFill\fP resource is set, and the
resources \fIleftColumn\fP and \fIrightColumn\fP are correctly set.
.TP 8
.B leftColumn (\fPClass\fB Column)
Specifies the left column to break text. Text lines started with a alphanumeric
character will automatically start at this column.
.TP 8
.B positionCallback (\fPClass\fB Callback)
Allows installing a callback that will be called every time the cursor is
moved and/or the file change its size. The callback is called with a pointer
containing the following data:
.nf
typedef struct {
    int line_number;
    int column_number;
    XawTextPosition insert_position;
    XawTextPosition last_position;
    Boolean overwrite_mode;
} XawTextPositionInfo;
.fi
This callback is intended to help programmers to write text editors based on
the Xaw widget set.
.TP 8
.B rightColumn (\fPClass\fB Column)
Specifies the right column to break text. Text lines started with a alphanumeric
character will automatically end at this column.

.SH TEXT SOURCE OBJECT
The textSrcObject was modified to allow showing its contents in more than one
window, and also store undo information. The new resources for the textSrcObject
are:
.TP 8
.B callback (\fPClass\fB Callback)
Previous versions of Xaw had this resource in the subclasses. This was changed
to make it possible to tell the callback the state of the text, when undo is
enabled.
.TP 8
.B enableUndo (\fPClass\fB Undo)
A boolean resource, that enables or disables the undo function. The default
value is False.
.TP 8
.B sourceChanged (\fPClass\fB Changed)
Like the callback resource, it was on the subclasses on previous versions. Now
it is in the textSrcObject to control the changed/unchanged state, when undo
is enabled.

.SH TEXT SINK OBJECT
The textSinkObject subclasses asciiSinkObject and multiSinkObject were slightly
changed to offer a new cursor shape, that indicates the input focus of the
text widget and allow setting its color. The new resource is:
.TP 8
.B cursorColor (\fPClass\fB Color)
Allows setting the cursor color of the text. This color is also used to draw
selected text.

.SH SIMPLE MENU WIDGET
The simpleMenuWidget algorithm to lay out menu entries was changed to
enable multiple columns when one single column does not fit in the screen.
It was also modified to enable sub menus.

.SH SME BSB OBJECT
A new resource was added to the smeBSBObject, to allow binding sub menus to
it. The new resource is:
.TP 8
.B menuName (\fPClass\fB MenuName)
The name of the popup widget to be popped up when the pointer is over the
menu entry, or NULL. Note that the named menu must be a child of the popup
parent of the smeBSBObject.

.SH RESTRICTIONS
.B Xaw
is actually being actively worked. Programs intending to be fully compatible
with future  releases  of  the  Xaw  library  should  use  only  the  public
interfaces. While  widget subclassification  is not  a bad,  and some  times
encouraged  programming   practice,  programs   that  access   private  data
structures may have problems  with newer releases,  in the current  stage of
the
.I Xaw
development. Several efforts are being done to avoid  such problems, and, at
least, guarantee that newer releases will be source and binary compatible.

.SH AUTHORS
The XFree86 additions and modifications to \fIXaw\fR,  were written by Paulo
Cesar Pereira de Andrade
