/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.macos;

import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.io.IOException;
import java.util.Properties;
import sun.awt.ObjectPeer;
import sun.awt.SunToolkit;
import sun.awt.image.ImageRepresentation;
import sun.awt.macos.MButtonPeer;
import sun.awt.macos.MCanvasPeer;
import sun.awt.macos.MCheckboxMenuItemPeer;
import sun.awt.macos.MCheckboxPeer;
import sun.awt.macos.MChoicePeer;
import sun.awt.macos.MDialogPeer;
import sun.awt.macos.MFileDialogPeer;
import sun.awt.macos.MFontPeer;
import sun.awt.macos.MFramePeer;
import sun.awt.macos.MLabelPeer;
import sun.awt.macos.MListPeer;
import sun.awt.macos.MMenuBarPeer;
import sun.awt.macos.MMenuItemPeer;
import sun.awt.macos.MMenuPeer;
import sun.awt.macos.MPanelPeer;
import sun.awt.macos.MPopupMenuPeer;
import sun.awt.macos.MPrintJob;
import sun.awt.macos.MScrollPanePeer;
import sun.awt.macos.MScrollbarPeer;
import sun.awt.macos.MTextAreaPeer;
import sun.awt.macos.MTextFieldPeer;
import sun.awt.macos.MWindowPeer;
import sun.awt.macos.MacClipboard;
import sun.awt.macos.MacFontMetrics;
import sun.awt.macos.MacImage;

public class MToolkit
extends SunToolkit {
    static ColorModel screenmodel;
    static Clipboard clipboard;

    public MToolkit() {
        SecurityManager.enablePrivilege("SuperUser");
        System.loadLibrary("PowerPlantAWT");
        SecurityManager.revertPrivilege();
        this.init();
    }

    public ButtonPeer createButton(Button button) {
        MButtonPeer mButtonPeer = new MButtonPeer(button);
        SunToolkit.peerMap.put(button, mButtonPeer);
        return mButtonPeer;
    }

    public TextFieldPeer createTextField(TextField textField) {
        MTextFieldPeer mTextFieldPeer = new MTextFieldPeer(textField);
        SunToolkit.peerMap.put(textField, mTextFieldPeer);
        return mTextFieldPeer;
    }

    public LabelPeer createLabel(Label label) {
        MLabelPeer mLabelPeer = new MLabelPeer(label);
        SunToolkit.peerMap.put(label, mLabelPeer);
        return mLabelPeer;
    }

    public ListPeer createList(List list) {
        MListPeer mListPeer = new MListPeer(list);
        SunToolkit.peerMap.put(list, mListPeer);
        return mListPeer;
    }

    public CheckboxPeer createCheckbox(Checkbox checkbox) {
        MCheckboxPeer mCheckboxPeer = new MCheckboxPeer(checkbox);
        SunToolkit.peerMap.put(checkbox, mCheckboxPeer);
        return mCheckboxPeer;
    }

    public ScrollbarPeer createScrollbar(Scrollbar scrollbar) {
        MScrollbarPeer mScrollbarPeer = new MScrollbarPeer(scrollbar);
        SunToolkit.peerMap.put(scrollbar, mScrollbarPeer);
        return mScrollbarPeer;
    }

    public ScrollPanePeer createScrollPane(ScrollPane scrollPane) {
        MScrollPanePeer mScrollPanePeer = new MScrollPanePeer(scrollPane);
        SunToolkit.peerMap.put(scrollPane, mScrollPanePeer);
        return mScrollPanePeer;
    }

    public TextAreaPeer createTextArea(TextArea textArea) {
        MTextAreaPeer mTextAreaPeer = new MTextAreaPeer(textArea);
        SunToolkit.peerMap.put(textArea, mTextAreaPeer);
        return mTextAreaPeer;
    }

    public ChoicePeer createChoice(Choice choice) {
        MChoicePeer mChoicePeer = new MChoicePeer(choice);
        SunToolkit.peerMap.put(choice, mChoicePeer);
        return mChoicePeer;
    }

    public FramePeer createFrame(Frame frame) {
        MFramePeer mFramePeer = new MFramePeer(frame);
        SunToolkit.peerMap.put(frame, mFramePeer);
        return mFramePeer;
    }

    public CanvasPeer createCanvas(Canvas canvas) {
        MCanvasPeer mCanvasPeer = new MCanvasPeer(canvas);
        SunToolkit.peerMap.put(canvas, mCanvasPeer);
        return mCanvasPeer;
    }

    public PanelPeer createPanel(Panel panel) {
        MPanelPeer mPanelPeer = new MPanelPeer(panel);
        SunToolkit.peerMap.put(panel, mPanelPeer);
        return mPanelPeer;
    }

    public WindowPeer createWindow(Window window) {
        MWindowPeer mWindowPeer = new MWindowPeer(window);
        SunToolkit.peerMap.put(window, mWindowPeer);
        return mWindowPeer;
    }

    public DialogPeer createDialog(Dialog dialog) {
        MDialogPeer mDialogPeer = new MDialogPeer(dialog);
        SunToolkit.peerMap.put(dialog, mDialogPeer);
        return mDialogPeer;
    }

    public FileDialogPeer createFileDialog(FileDialog fileDialog) {
        MFileDialogPeer mFileDialogPeer = new MFileDialogPeer(fileDialog);
        SunToolkit.peerMap.put(fileDialog, mFileDialogPeer);
        return mFileDialogPeer;
    }

    public MenuBarPeer createMenuBar(MenuBar menuBar) {
        MMenuBarPeer mMenuBarPeer = new MMenuBarPeer(menuBar);
        SunToolkit.peerMap.put(menuBar, mMenuBarPeer);
        return mMenuBarPeer;
    }

    public MenuPeer createMenu(Menu menu) {
        MMenuPeer mMenuPeer = new MMenuPeer(menu);
        SunToolkit.peerMap.put(menu, mMenuPeer);
        return mMenuPeer;
    }

    public PopupMenuPeer createPopupMenu(PopupMenu popupMenu) {
        MPopupMenuPeer mPopupMenuPeer = new MPopupMenuPeer(popupMenu);
        SunToolkit.peerMap.put(popupMenu, mPopupMenuPeer);
        return mPopupMenuPeer;
    }

    public MenuItemPeer createMenuItem(MenuItem menuItem) {
        MMenuItemPeer mMenuItemPeer = new MMenuItemPeer(menuItem);
        SunToolkit.peerMap.put(menuItem, mMenuItemPeer);
        return mMenuItemPeer;
    }

    public CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem checkboxMenuItem) {
        MCheckboxMenuItemPeer mCheckboxMenuItemPeer = new MCheckboxMenuItemPeer(checkboxMenuItem);
        SunToolkit.peerMap.put(checkboxMenuItem, mCheckboxMenuItemPeer);
        return mCheckboxMenuItemPeer;
    }

    static native void addNativeEventInfo(AWTEvent var0, int var1);

    static void postEvent(AWTEvent aWTEvent) {
        Object object;
        EventQueue eventQueue = SunToolkit.theEventQueue;
        Object object2 = aWTEvent.getSource();
        if (object2 != null && (object = SunToolkit.targetToPeer(object2)) != null && ((ObjectPeer)object).getEventQueue() != null) {
            eventQueue = ((ObjectPeer)object).getEventQueue();
        }
        eventQueue.postEvent(aWTEvent);
    }

    static boolean prepareScrImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (n == 0 || n2 == 0) {
            return true;
        }
        MacImage macImage = (MacImage)image;
        if (macImage.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        if (n < 0) {
            n = -1;
        }
        if (n2 < 0) {
            n2 = -1;
        }
        ImageRepresentation imageRepresentation = macImage.getImageRep();
        return imageRepresentation.prepare(imageObserver);
    }

    static int checkScrImage(Image image, int n, int n2, ImageObserver imageObserver) {
        int n3;
        MacImage macImage = (MacImage)image;
        if (n == 0 || n2 == 0) {
            n3 = 32;
        } else {
            if (n < 0) {
                n = -1;
            }
            if (n2 < 0) {
                n2 = -1;
            }
            n3 = macImage.getImageRep().check(imageObserver);
        }
        return macImage.check(imageObserver) | n3;
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return MToolkit.checkScrImage(image, n, n2, imageObserver);
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return MToolkit.prepareScrImage(image, n, n2, imageObserver);
    }

    public Image createImage(ImageProducer imageProducer) {
        return new MacImage(imageProducer);
    }

    static native ColorModel makeColorModel();

    static ColorModel getStaticColorModel() {
        if (screenmodel == null) {
            screenmodel = MToolkit.makeColorModel();
        }
        return screenmodel;
    }

    public ColorModel getColorModel() {
        return MToolkit.getStaticColorModel();
    }

    public native int getScreenResolution();

    protected native int getScreenWidth();

    protected native int getScreenHeight();

    public FontPeer getFontPeer(String string, int n) {
        return new MFontPeer(string, n);
    }

    public FontMetrics getFontMetrics(Font font) {
        return MacFontMetrics.getFontMetrics(font);
    }

    public PrintJob getPrintJob(Frame frame, String string, Properties properties) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        MPrintJob mPrintJob = null;
        try {
            mPrintJob = new MPrintJob("AWT Print");
        }
        catch (IOException iOException) {}
        return mPrintJob.initJob();
    }

    public native void beep();

    public Clipboard getSystemClipboard() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSystemClipboardAccess();
        }
        if (clipboard == null) {
            clipboard = new MacClipboard("System");
        }
        return clipboard;
    }

    protected native void loadSystemColors(int[] var1);

    public static final Object targetToPeer(Object object) {
        return SunToolkit.targetToPeer(object);
    }

    protected static void targetDisposedPeer(Object object, Object object2) {
        if (object != null && object2 != null && SunToolkit.peerMap.get(object) == object2) {
            SunToolkit.peerMap.remove(object);
        }
    }

    public native void init();

    public void sync() {
    }
}

