/*
 * Decompiled with CFR 0.152.
 */
package netscape.security;

import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;

public final class Privilege
implements Codable {
    static final int VERSION = 1;
    public static final int N_PERMISSIONS = 3;
    public static final int FORBIDDEN = 0;
    public static final int ALLOWED = 1;
    public static final int BLANK = 2;
    private int itsPerm;
    public static final int N_DURATIONS = 3;
    public static final int SCOPE = 0;
    public static final int SESSION = 1;
    public static final int FOREVER = 2;
    private int itsDuration;
    private boolean itsInited = false;
    private static Privilege[][] itsPrivilegeCache = new Privilege[3][3];

    public Privilege() {
    }

    private Privilege(int n, int n2) {
        this.itsPerm = n;
        this.itsDuration = n2;
        this.itsInited = true;
    }

    public static Privilege findPrivilege(int n, int n2) {
        return itsPrivilegeCache[n][n2];
    }

    public static int add(int n, int n2) {
        if (n < n2) {
            return n;
        }
        return n2;
    }

    public static Privilege add(Privilege privilege, Privilege privilege2) {
        if (privilege.itsPerm < privilege2.itsPerm) {
            return privilege;
        }
        return privilege2;
    }

    public boolean samePermission(Privilege privilege) {
        return privilege.itsPerm == this.itsPerm;
    }

    public boolean samePermission(int n) {
        return this.itsPerm == n;
    }

    public boolean sameDuration(Privilege privilege) {
        return privilege.itsDuration == this.itsDuration;
    }

    public boolean sameDuration(int n) {
        return this.itsDuration == n;
    }

    public boolean isAllowed() {
        return this.itsPerm == 1;
    }

    public boolean isForbidden() {
        return this.itsPerm == 0;
    }

    public boolean isBlank() {
        return this.itsPerm == 2;
    }

    public int getPermission() {
        return this.itsPerm;
    }

    public int getDuration() {
        return this.itsDuration;
    }

    public String toString() {
        String string = null;
        String string2 = null;
        switch (this.itsPerm) {
            case 1: {
                string = "allowed";
                break;
            }
            case 0: {
                string = "forbidden";
                break;
            }
            case 2: {
                string = "blank";
                break;
            }
        }
        switch (this.itsDuration) {
            case 0: {
                string2 = String.valueOf(string) + " in the current scope";
                break;
            }
            case 1: {
                string2 = String.valueOf(string) + " in the current browser session";
                break;
            }
            case 2: {
                string2 = String.valueOf(string) + " forever";
                break;
            }
        }
        return string2;
    }

    public void describeClassInfo(ClassInfo classInfo) {
        classInfo.addClass("Privilege", 1);
        classInfo.addField("Perm", (byte)8);
        classInfo.addField("Duration", (byte)8);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeInt("Perm", this.itsPerm);
        encoder.encodeInt("Duration", this.itsDuration);
    }

    public void decode(Decoder decoder) throws CodingException {
        if (this.itsInited) {
            return;
        }
        this.itsInited = true;
        this.itsPerm = decoder.decodeInt("Perm");
        this.itsDuration = decoder.decodeInt("Duration");
    }

    public void finishDecoding() throws CodingException {
    }

    static {
        int n = 0;
        while (n < 3) {
            int n2 = 0;
            while (n2 < 3) {
                Privilege.itsPrivilegeCache[n][n2] = new Privilege(n, n2);
                ++n2;
            }
            ++n;
        }
    }
}

