/*
 * Decompiled with CFR 0.152.
 */
package java.text;

final class WordBreakTable {
    static final byte MARK_MASK = -128;
    static final byte INDEX_MASK = 127;
    private static final int INITIAL_STATE = 1;
    private static final int END_STATE = 0;
    private byte[] data;
    private int cols;

    public WordBreakTable(int n, byte[] byArray) {
        this.data = byArray;
        this.cols = n;
    }

    public int get(int n, int n2) {
        return this.data[(n & 0x7F) * this.cols + n2];
    }

    public boolean isMarkState(int n) {
        return (n & 0xFFFFFF80) != 0;
    }

    public boolean isEndState(int n) {
        return (n & 0x7F) == 0;
    }

    public int initialState() {
        return 1;
    }
}

