.TH Audio 1.0 "October 1996" Audio
.UC
.SH NAME
\fBAudio\fP \- the AfterStep Audio module
.SH SYNOPSIS
\fBAudio\fP is spawned by \fBafterstep\fP, so no command line invocation will 
work.  From within the \fI.steprc\fP file, \fBAudio\fP is spawned as 
follows:
.nf
.sp
Module Audio 
.sp
.nf
or from within an afterstep pop-up menu:
.sp
.nf
Popup "Module-Popup"
	Title	"Modules"
	Module	"Wharf"		Wharf
	Module	"FvwmIdentify"	FvwmIdent
	Module	"Audio"		Audio
	Module	"Pager"		Pager 0 3
EndPopup
.fn
.SH DESCRIPTION
The \fBAudio\fP module communicates with the AfterStep window manager to bind
audio sounds to window manager actions. Different audio queues may be
assigned to any window manager action. \fBAudio\fP can be used with
any independent audio player, and therefore requires no special audio library 
APIs of its own. Simple in its design, it merely binds the audio filenames
to particular actions and forks off the audio player program with the
appropriate filename when that action occurs. 

\fBAudio\fP can also have builtin support for the rplay library.

.SH CONFIGURATION OPTIONS
\fBAudio\fP reads the same \fI.steprc\fP file as \fBafterstep(1)\fP reads when 
it starts up, and looks for certain configuration options:

.IP "*AudioPlayCmd \fI/usr/bin/X11/demos/auplay\fP"
This determines the independent audio player program that will actually
play the sounds.  If the play command is set to \fIbuiltin-rplay\fP
then the builtin rplay support will be used.  For example:
.sp
*AudioPlayCmd \fIbuiltin-rplay\fP

.IP "*AudioDir \fI/usr/lib/sounds\fP"
Specifies the directory to look for the audio files.  This option
is ignored when rplay is used.

.IP "*AudioDelay \fI5\fP"
Specifies that sound events will only be played if they occur
at least 5 seconds after the previous event.  Sounds events that
occur during the delay period are ignored.  This option is useful if 
you don't want several sounds playing at the same time.  The default
delay is 0 which disables the audio delay.

.IP "*AudioRplayHost \fIhostname\fP"
Specifies what host the sounds will play on.  The \fIhostname\fP
can also be an environment variable such as $HOSTDISPLAY.
This option is only valid with builtin rplay support.

.IP "*AudioRplayPriority \fI0\fP"
Specifies what priority will be assigned to the sounds when they
are played.  This option is only valid with builtin rplay support.

.IP "*AudioRplayVolume \fI127\fP"
Specifies what volume will be assigned to the sounds when they
are played.  This option is only valid with builtin rplay support.

.IP "*Audio \fIwindow-manager_action audio_filename\fP"
Binds particular window manager actions to sound queues.
.nf
.sp
*Audio startup TaDa.au
*Audio shutdown Elvis_Left.au
*Audio unknown doh.au
*Audio add_window drip.au
*Audio raise_window swoosh.au
*Audio lower_window swoosh.au
*Audio focus_change boing.au
*Audio destroy_window explosion.au
*Audio iconify ploop.au
*Audio deiconify ploop.au
*Audio toggle_paging fwop.au
*Audio new_page beam_trek.au
*Audio new_desk beam_trek.au
*Audio configure_window huh.au
*Audio window_name beep.au
*Audio icon_name beep.au
*Audio res_class beep.au
*Audio res_name beep.au
*Audio end_windowlist twang.au
.sp
.fi
.SH INVOCATION
The invocation method was shown in the synopsis section. No command line
invocation is possible. \fBAudio\fP must be invoked by the \fBafterstep\fP
window manager.
.sp
.SH BUGS
.sp
.SH COPYRIGHTS
This module is a port of the \fBFvwmAudio\fP module to \fBAfterStep\fP 
by Frank Fejes. The concept for interfacing this module to the Window
Manager, is original work by Robert Nation.

Copyright 1996, Frank Fejes.
Copyright 1994, Mark Boyns and Mark Scott. No guarantees or warranties or 
anything are provided or implied in any way whatsoever. Use this program at 
your own risk. Permission to use this program for any purpose is given,
as long as the copyright is kept intact.
.sp
.SH AUTHORS
Frank Fejes <frank@ssax.com> -- application
.sp
Dan Weeks <dan@mango.sfasu.edu> -- man page
